/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: key_dreh.c 
 * Info: Routinen zum Einlesen des Drehgebers
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 06.10.05
*/

#include <avr/io.h>

#include "../mcu.h"

#ifdef DREH_AVAILABLE 

// Anzahl der Aufrufe von dreh_isr, die zum entprellen genutzt werden
#define ENTPRELLEN 5	

#define DREH_A 0x10
#define DREH_B 0x20
#define DREH_TAST 0x40
#define DREH_ALL (DREH_A+DREH_B+DREH_TAST)

const int8_t graytab[] = { 0,-1,1,0, 1,0,0,-1, -1,0,0,+1, 0,1,-1,0 };
volatile static unsigned char graycode = 0;
int drehgeber;
char drehtaste=0;	// muss per hand zurckgesetzt werden!
volatile static char drehtaste_tmp=0;	

void dreh_init(void){
	DDRC &= ~ DREH_ALL; 	//Drehkontakte als Input
	PORTC |= DREH_ALL;	// Alle Pullups an.
	drehgeber=0x000;
}


/* Interrupt Routine, die den Drehgeber ausliest und die Taste entprellt */
void dreh_isr(void){
  graycode >>= 2;          		// old state to bit 1, 0

  if( (PINC & DREH_A) ==DREH_A )	//A=1 ?
    graycode |= 0x04;                   // new A state to bit 4
  if( (PINC & DREH_B) ==DREH_B )	//B=1 ?
    graycode |= 0x08;			// new B state to bit 5
  
  drehgeber += graytab[graycode];	// +/- 1 if state change
  
  if ((PINC & DREH_TAST) ==0){		// Taste gedrckt?
	  if (drehtaste_tmp < ENTPRELLEN){
		drehtaste_tmp++;	// Entpreller hochzhlen
	  	if (drehtaste_tmp ==ENTPRELLEN)	//Genug entprellt? 
			drehtaste++;
	  }
  } else {	// Wenn Taste nicht gedrckt, dann Entpreller lschen
  	drehtaste_tmp=0;
  }
}

/* Liest den Zustand der Taste des Drehgebers aus
   Gibt die Anzahl der Tastendrcke seit dem letzten Aufruf aus.
*/
char dreh_read(void){
	char retVal=drehtaste;
	drehtaste=0;
	return retVal;
}
#endif
