/* c't Mikrocontroller-im-LAN Demo Source
 * Datei: adc_filter.c 
 * Info: Routinen zum Filtern der analogen messwerte
 * Autor: Benjamin Benz (bbe@heise.de)
 * Datum: 05.10.05
*/
#include <math.h>
#include <stdlib.h>
#include "mcu.h"

#ifdef FILTER_AVAILABLE
// Soll der Filter ein oder zweistufig sein? Achtung, die 2. Stufe kann
// ueberschwingen

//#define ZWEISTUFIG
#define GLIEDER 2

static int delay_x[GLIEDER+1];		// Puffer fuer alte Eingabe-Werte
static float delay_z[GLIEDER+1]; 	// Puffer fuer alte Zwischenergebnisse
#ifdef ZWEISTUFIG
	static float delay_y[GLIEDER+1];	// Puffer fuer alte Ergebnisse
#endif

//Filter-Entwurf mit: http://www.nauticom.net/www/jdtaft/babutter.htm
// Koeffizienten 1. Filter-Stufe
const float a1[GLIEDER+1] = {0, -1.8445877, 0.9536256};
const float b[GLIEDER+1] = { 1, 0, -1 };
// Koeffizienten 2. Filter-Stufe (b-Werte identisch mit denen der 1.Stufe	
#ifdef ZWEISTUFIG
	const float a2[GLIEDER+1] = {0, -1.8770182, 0.9594707};
#endif

// Gleitender Mittelwert des Stromfuehlers
float adc_mean=0;	

//Gewichtungsfaktor fr den gleitenden Mittelwert. 
//je kleiner FORGET ist, desto mehr werte werden bercksichtigt 
#define FORGET 0.01

int filter(int in){ 
	unsigned char i;	
	
	for (i=0; i< GLIEDER; i++){	// Delay the data
		delay_x[i]=delay_x[i+1]; // Input-Daten-Delay-Kette	
		delay_z[i]=delay_z[i+1]; // Zwischen-Daten-Delay-Kette
#ifdef ZWEISTUFIG
		delay_y[i]=delay_y[i+1]; // Output-Daten-Delay-Kette
#endif
	}	
	
	delay_x[GLIEDER] = in;	// New Input value
	
	// Erste Filterstufe:  Ergebnisse nach delay_z
	delay_z[GLIEDER] =   b[0] * delay_x[GLIEDER-0]
			    + b[1] * delay_x[GLIEDER-1]
			    + b[2] * delay_x[GLIEDER-2]
			    - a1[1] * delay_z[GLIEDER-1]
			    - a1[2] * delay_z[GLIEDER-2];
			
	// Zweite Filterstufe:  Ergebnisse nach delay_y		
#ifdef ZWEISTUFIG
	delay_y[GLIEDER] =   b[0] * delay_z[GLIEDER-0] 
			    + b[1] * delay_z[GLIEDER-1] 
			    + b[2] * delay_z[GLIEDER-2]
			    - a2[1] * delay_y[GLIEDER-1]
			    - a2[2] * delay_y[GLIEDER-2];
	
	//Gleitenden Mittelwert berechnen			    
	adc_mean=adc_mean * (1- FORGET) + abs(delay_y[GLIEDER])*FORGET; 
			    
	return (int)floor(delay_y[GLIEDER]);	// Ausgabe nach 2. Stufe
#else
	//Gleitenden Mittelwert berechnen			    
	adc_mean=adc_mean * (1- FORGET) + abs(delay_z[GLIEDER])*FORGET;
	
	return (int)floor(delay_z[GLIEDER]);	// Ausgabe nach 1. Stufe
#endif

}


void filter_init(void){
	int i;
	for (i=0; i<GLIEDER+1; i++){
		delay_x[i]=0; 
#ifdef ZWEISTUFIG
		delay_y[i]=0;
#endif
		delay_z[i]=0;
	}
}
#endif
