#ifndef EXCHANGERATEREADER_H
#define EXCHANGERATEREADER_H

#include <QMap>
#include <QPair>
#include <QDate>
#include <QObject>
#include <QHttp>
#include <QTemporaryFile>

typedef QMap<QPair<QDate,QString>, double> ExchangeRates;

class ExchangeRateReader : public QObject
{
    Q_OBJECT

public:
    ExchangeRateReader();

    const ExchangeRates* rates() const { return &mExchangeRates; }

private slots:
    void slotDownloadDone( bool );

private:
    ExchangeRates mExchangeRates;

    QHttp mHttp;
    QTemporaryFile mFile;
};



#endif /* EXCHANGERATEREADER_H */

