'***************************************************************************************************************************
' USBSecure Professional 2.00 (C) R. Hohmann 
' fr Windows 2000/XP - 02/2006
'***************************************************************************************************************************

'**Start Encode**

On Error Resume Next

version = "2.00"

Set Reg = GetObject("winmgmts:root\Default:StdRegProv")
result = Reg.GetStringValue(HKEY_LOCAL_MACHINE, "SYSTEM\CurrentControlSet\Services\USBSecure\Parameters", "AppParameters", ProgramPath)
ProgramPath = Right(ProgramPath, Len(ProgramPath) - 1)
ProgramPath = Left(ProgramPath, Len(ProgramPath) - 15)
Set Shell = CreateObject("Wscript.Shell")
Set fs = CreateObject("Scripting.FileSystemObject")
Set IniFile = fs.OpenTextFile(ProgramPath & "\USBSecure.ini", 1, false)
Set oDrives = fs.Drives

Const HKEY_LOCAL_MACHINE = &H80000002
Dim UsbDevices(255)
Dim VidPid(255)
Dim UsbDeviceDescription(255)
Dim AllowedUsbDevices(255)
Dim AllowedCdRomUsers(2000)
Dim AllowedFloppyUsers(2000)
Dim UsbEnableList(255)
Dim UsbEnableListDescription(255)
Dim Logbuffer(255)
Dim RegistryString(255)
Dim ExistingRegDevices(255)

Public server   ' Name des USBSecure-Servers
Public loglevel   ' 1 = normal, 2 = full, 3 = debug
Public ViolationShutdown   ' 1 = Rechner durchstarten bei nicht deaktivierbarem Gert, 0 = nicht durchstarten
Public GlobalViolationShutdown   ' = 0 wenn Datei NoShutdown.txt existiert


ScriptCounter = 0   ' zhlt die Do-Loop Schleifen
AllowedDeviceCounter = 0   ' zhlt die erlaubten USB-Gerte
a5 = "{a5dcbf10-6530-11d2-901f-00c04fb951ed}"   ' Registry-String

' Name des USBSecure-Servers ermitteln - der Server mit der Freigabe devices$
If fs.FileExists(ProgramPath & "\USBSecure.ini") Then
  Call ReadUSBSecureIni()
Else
  IniNotFound = 1
End If
   

' Logfile zum Schreiben ffnen
Set LogFile = fs.OpenTextFile(ProgramPath & "\USBSecure.log", 8, true)


' USB-Konfigurationsdatei (Whitelist)
UsbCfgFileName = ProgramPath & "\usb.cfg"

' Kein Shutdown wenn NoShutdown.txt existiert
If fs.FileExists("\\" & Server & "\Devices$\NoShutdown.txt") Then 
  GlobalViolationShutdown = 0
Else
  GlobalViolationShutdown = 1
End If
If GlobalViolationShutdown = 0 Then ViolationShutdown = 0


'==================================================================================================


Do
    ' readerror = 1 wenn Lesen von der Festplatte nicht mehr mglich ist (beim Shutdown)
    readerror = 0 
    
    ' UsbMustBeDisabled enthlt die Information, ob USB deaktiviert werden soll 
    UsbMustBeDisabled = 0 
    
    ' UsbMustBeEnabled enthlt die Information, ob USB eingeschaltet werden soll 
    UsbMustBeEnabled = 0 
    
    'BootFlag = 0 => Initialisierungsroutine soll laufen (.cfg-Dateien kopieren etc.), BootFlag = 1 => Initialisierungsroutine soll nicht laufen

    ' Benutzernamen aus Registry ermitteln
    UserName = Shell.RegRead("HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon\AltDefaultUserName")
    UserName = LCase(UserName)
    
    '***************************************************************************************************************************
    ' Wenn der Rechner gestartet wurde, der USBSecure-Dienst neu gestartet wurde oder 
    ' der Benutzername sich gendert hat => Konfigurationsdateien vom Server holen
    '***************************************************************************************************************************
    If BootFlag = 0 or UserNameOld <> UserName Then 
        Call logging("=======================================================")
        If IniNotFound = 1 Then Call logging(ProgramPath & "\USBSecure.ini nicht gefunden")
        If loglevel > 1 Then Call logging("Loglevel: " & loglevel)
        Call logging("Konfigurationsdateien werden kopiert...")
        If loglevel > 1 Then Call logging("USBSecure Server ist " & Server)
        result1 = shell.Run("cmd /c copy /Y \\" & Server & "\Devices$\cd.cfg " & Chr(34) & ProgramPath & Chr(34), 0, True)
        result2 = shell.Run("cmd /c copy /Y \\" & Server & "\Devices$\floppy.cfg " & Chr(34) & ProgramPath & Chr(34), 0, True)
        result3 = shell.Run("cmd /c copy /Y \\" & Server & "\Devices$\usb.cfg " & Chr(34) & ProgramPath & Chr(34), 0, True)
        If loglevel = 3 Then 
          Call logging("USBSecure Professional Version ist " & version)
          If result1 = 0 Then 
            Call logging("cd.cfg erfolgreich kopiert")
          Else
            Call logging("Kopieren von cd.cfg fehlgeschlagen")          	
          End If
          If result2 = 0 Then 
            Call logging("floppy.cfg erfolgreich kopiert")
          Else
            Call logging("Kopieren von floppy.cfg fehlgeschlagen")          	
          End If
          If result3 = 0 Then 
            Call logging("usb.cfg erfolgreich kopiert")
          Else
            Call logging("Kopieren von usb.cfg fehlgeschlagen")          	
          End If
        End If
        ' CheckForBandits-Timer setzen => CheckForBandits-Routine wartet 6 Intervalle bis zum Check
        CheckForBandits = 6
        BootFlag = 0
        DevicesDisabled = 0   
        DevicesEnabled = 0
        If loglevel = 3 Then Call logging("ViolationShutdown: " & ViolationShutdown)
    End If 

    ' wenn der Benutzername sich gendert hat, wird die zweite USB-Einschaltung unterdrckt
    If UserNameOld <> UserName Then 
      SecondEnable = 0 
      If scriptcounter > 0 Then logdevices = 1
    End If

    ' Benutzernamen fr nchsten Schleifendurchlauf speichern
    UserNameOld = UserName   


    '***************************************************************************************************************************
    ' USB-Check
    '***************************************************************************************************************************
    Key = "SYSTEM\CurrentControlSet\Enum\USB"
    return = Reg.EnumKey(HKEY_LOCAL_MACHINE, Key, subkeys)
    ' Feld subkeys enthlt jetzt alle USB-Gertetypen aus HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\USB    
    ' ins Feld VidPid() schreiben
    DeviceTypeCounterOld = DeviceTypeCounter
    UsbDevicesCountOld = UsbDevicesCount
    DeviceTypeCounter = 0
    UsbDevicesCount = 0
    DevRefCountOld = DevRefCount
    DevRefCount = 0
    For Each subkey In subkeys
        temp = LCase(Left(subkey,1))
        If Asc(temp) < 97 or Asc(temp) > 122 Then readerror = 1   'readerror = 1 setzen, falls Lesen der USB-Gerte fehlschlgt (nur "v"id oder "r"oot sind erlaubt)
        VidPid(DeviceTypeCounter) = subkey
        DeviceTypeCounter = DeviceTypeCounter + 1
    Next
    
    ' alle Untereintrge von HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Enum\USB lesen, um die Gerteeintrge zu ermitteln
    For DeviceCounter = 0 To DeviceTypeCounter - 1
        Key = "SYSTEM\CurrentControlSet\Enum\USB" & "\" & VidPid(DeviceCounter)
        return = Reg.EnumKey(HKEY_LOCAL_MACHINE, Key, subkeys)
        i = 0
        For Each subkey In subkeys
           UsbDevices(i) = subkey
           i = i + 1
           RegistryString(UsbDevicesCount) = VidPid(DeviceCounter) & "#" & subkey & "#" & a5 & "\#\Control" ' zum Lesen von "linked" in DeviceClasses
           DevRef = ""   ' DeviceReference: falls vorhanden => Gert ist physikalisch angeschlossen
           DevRef = Shell.RegRead("HKLM\" & "SYSTEM\CurrentControlSet\Enum\USB\" & VidPid(DeviceCounter) & "\" & subkey & "\Control\DeviceReference")
           If DevRef <> "" Then DevRefCount = DevRefCount + 1           
           UsbDevicesCount = UsbDevicesCount + 1
        Next
        Key = "SYSTEM\CurrentControlSet\Enum\USB" & "\" & VidPid(DeviceCounter) & "\" & UsbDevices(0)
        ' Gertebeschreibungen ermitteln und ins Feld UsbDeviceDescription() schreiben
        Description = Shell.RegRead("HKLM\" & Key & "\DeviceDesc")
        UsbDeviceDescription(DeviceCounter) = Description
        ExistingRegDevices(DeviceCounter) = Description & ": " & VidPid(DeviceCounter)
    Next
    If DevRefCount > DevRefCountOld Then DevicesEnabled = 0 ' Angeschlossene, erlaubte Gerte einschalten

    If DeviceTypeCounterOld <> 0 Then    	
    	If DeviceTypeCounterOld <> DeviceTypeCounter or UsbDevicesCountOld <> UsbDevicesCount Then ' Check von "eine Klasse, n Gerte"
    		DevicesDisabled = 0
                logdevices = 1
    	End If    	
    End If
     
    If DeviceTypeCounterOld <> 0 Then    	
    	If DeviceTypeCounterOld <> DeviceTypeCounter or Scriptcounter = 1 Then logdevices = 1 ' Gerte im Logfile auflisten
    End If

    Set fs = CreateObject("Scripting.FileSystemObject")
    Set CfgFile = fs.OpenTextFile(UsbCfgFileName)
    
    ' Erlaubte USB-Gerte aus usb.cfg ins Feld AllowedUsbDevices() einlesen fr den angemeldeten Benutzer - nur 5 Mal wg. Performance
    If ScriptCounter < 5 or BootFlag = 0 or UserNameOld <> UserName Then
        EverythingAllowed = 0
        UsbUserNotExisting = 1
        AllowedDeviceCounter = 0
        read = 0
        Do Until CfgFile.AtEndOfStream
            zeile = CfgFile.ReadLine
            If Left(zeile,1) = "[" Then
                CfgUserName = Trim(zeile)
                CfgUserName = Mid(zeile,2,Len(CfgUserName)-2)
                CfgUserName = LCase(CfgUserName)
                If CfgUserName = UserName or LCase(CfgUserName) = "allusers" Then
                    read = 1
                    UsbUserNotExisting = 0
                Else
                    read = 0
                End If
            End If    
            If read = 1 Then
                If Left(LTrim(zeile),1) <> "#" and Left(LTrim(zeile),1) <> "[" and Len(Trim(zeile)) > 0 Then 
                  AllowedUsbDevices(AllowedDeviceCounter) = RTrim(zeile) ' rechte Leerzeichen kappen, linke Leerzeichen knnten wichtig sein
                  AllowedDeviceCounter = AllowedDeviceCounter + 1    
                End If
                If Trim(zeile) = "*" Then EverythingAllowed = 1
            End If
        Loop
    End If
    CfgFile.Close

    If UsbUserNotExisting = 1 Then
        If BootFlag = 0 Then 
            ' USB am Ende des Skriptes ausschalten
            UsbMustBeDisabled = 1
            Call logging("USB-Port AUSGESCHALTET fuer Benutzer " & Username & " - Benutzer nicht in usb.cfg vorhanden")
            UsbDisabled = 1
        End If
    End If         	

      ' Gerte ermitteln, die am Ende des Skripts eingeschaltet werden sollen
      If DevicesEnabled = 0 Then
        If EverythingAllowed = 1 Then
          UsbEnableList(0) = "*"
      	  enable_counter = 1
        Else	
          enable_counter = 0
          For x = 0 To DeviceTypeCounter - 1
            OK = False
            For y = 0 To AllowedDeviceCounter - 1
                CompareString = AllowedUsbDevices(y)
                If Left(CompareString,1) = "*" Then CompareString = UsbDeviceDescription(x) & Right(CompareString, Len(CompareString) - 1 )
                If UsbDeviceDescription(x) & ": " & VidPid(x) = CompareString Then 
                  UsbEnableList(enable_counter) = VidPid(x)   ' Information fr das Disable-Kommando
                  UsbEnableListDescription(enable_counter) = UsbDeviceDescription(x)   ' Information fr das Logfile
                  enable_counter = enable_counter + 1
                End If
            Next
          Next
        End If
      End If
      

      ' berprfen, ob sich die Anzahl der gelinkten Gerte (eingesteckt und eingeschaltet) gendert hat. Falls ja => Deaktivierungs-Routine
      LinkedCountOld = LinkedCount 
      LinkedCount = 0
      For i = 0 to UsbDevicesCount - 1
        link = 0
        link = Shell.RegRead("HKLM\SYSTEM\CurrentControlSet\Control\DeviceClasses\" & a5 & "\##?#USB#" & RegistryString(i) & "\Linked")
        If link = 1 Then LinkedCount = LinkedCount + 1
      Next 
      If LinkedCount <> LinkedCountOld Then 
        DevicesDisabled = 0
      End If


    ' Felder AllowedUsbDevices() und UsbDeviceDescription() vergleichen
    BufferCounter = 0
    If DevicesDisabled = 0 Then
      DevicesDisabled = 1
      devcondisable = Chr(34) & ProgramPath & "\devcon.exe" & Chr(34) & " disable" 
      If EverythingAllowed = 0 and UsbUserNotExisting = 0 Then
        For x = 0 To DeviceTypeCounter - 1
            OK = False
            For y = 0 To AllowedDeviceCounter - 1
                CompareString = AllowedUsbDevices(y)
                If Left(CompareString,1) = "*" Then CompareString = UsbDeviceDescription(x) & Right(CompareString, Len(CompareString) - 1 ) '   Wildcard *?
                If UsbDeviceDescription(x) & ": " & VidPid(x) = CompareString Then OK = True
            Next
            If OK = False Then 
            	 ' Installiertes Gert ist nicht in usb.cfg vorhanden
                 If UsbDisabled = 0 or LastViolation <> UsbDeviceDescription(x) & ": " & VidPid(x) Then
                       pos = InStr(VidPid(x),"&")
                       If pos > 0 Then 
                       	 DisableDevice = Left(VidPid(x),pos-1) & Chr(34) & "&" & Chr(34) & Right(VidPid(x), Len(VidPid(x)) - pos)
                       Else 
                         DisableDevice = VidPid(x)   ' z.B. Root_Hub
                       End If
                       devcondisable = devcondisable & " USB\" & DisableDevice                     
                       Call AddLogbuffer("USB-Geraet AUSGESCHALTET fuer Benutzer " & Username & " - verbotenes USB-Geraet: " & UsbDeviceDescription(x) & ": " & VidPid(x))  
  	               ' Administrator bei verbotenem USB-Gert benachrichtigen (auskommentiert)
  	               ' If readerror <> 1 Then Return = shell.Run("net send USBSecure-Console " & Chr(32) & "USBSecure: Verbotenes USB-Gert bei Benutzer " & UserName & ": " & UsbDeviceDescription(x) & Chr(32), 0, False)	         
                       LastViolation = UsbDeviceDescription(x) & ": " & VidPid(x)
                 End If
            End If
        Next
        If readerror = 0 Then 
          Return = shell.Run(devcondisable, 0, True) ' USB-Gerte deaktivieren
          Call logging(BufferCounter & " USB-Geraet(e) ausgeschaltet...") 
          Call WriteLogbuffer
          CheckForBandits = 6
          If loglevel = 3 Then Call logging("Starte DevconDisable fuer Benutzer " & Username  & " => " & devcondisable)
        End If 
      End If
    End If 
    
    ' USB einschalten, da der Benutzer jedes USB-Gert verwenden darf (* in usb.cfg)
    If EverythingAllowed = 1 Then
       If UsbDisabled = 1 or BootFlag = 0 Then
           UsbMustBeEnabled = 1   ' Einschaltung am Ende des Skriptes 
           Call logging("USB-Geraete EINGESCHALTET fuer Benutzer " & Username & " - Alle USB-Geraete erlaubt")
           UsbDisabled = 0
       End If
    End If


    '***************************************************************************************************************************
    ' cd.cfg und floppy.cfg einlesen
    '***************************************************************************************************************************
    If ScriptCounter < 5 or BootFlag = 0 or UserNameOld <> UserName Then
        ' max. CD und Floppy-Benutzer: 2000. Falls die Anzahl nicht reicht, muss diese Schleife
        ' und die Deklaration am Anfang des Skriptes gendert werden.
        For i = 0 to 2000
            AllowedCdRomUsers(i) = ""
            AllowedFloppyUsers(i) = ""
        next
  
        Set fs = CreateObject("Scripting.FileSystemObject")
        Set CfgFile = fs.OpenTextFile(ProgramPath & "\cd.cfg")
        CdRomUsersCounter = 0
        Do Until CfgFile.AtEndOfStream
            rline = LCase(CfgFile.ReadLine)
            If Len(rline) > 1 Then   ' keine Leerzeilen einlesen
              	 AllowedCdRomUsers(CdRomUsersCounter) = rline
                 CdRomUsersCounter = CdRomUsersCounter + 1
            End If
        Loop
        CfgFile.Close
  
        Set fs = CreateObject("Scripting.FileSystemObject")
        Set CfgFile = fs.OpenTextFile(ProgramPath & "\floppy.cfg")
        FloppyUsersCounter = 0
        Do Until CfgFile.AtEndOfStream
            rline = LCase(CfgFile.ReadLine)
            If Len(rline) > 1 Then   ' keine Leerzeilen einlesen
                AllowedFloppyUsers(FloppyUsersCounter) = rline
	        FloppyUsersCounter = FloppyUsersCounter + 1
	    End If
        Loop
        CfgFile.Close
    End If


    '***************************************************************************************************************************
    ' CD-Erlaubnis prfen
    '***************************************************************************************************************************
    cdrom = 0
    for i = 0 to CdRomUsersCounter
        If Username = Trim(AllowedCdRomUsers(i)) then cdrom = 1
    next

    If CdRomUsersCounter > 2000 Then
    	cdrom = 0
    	Call logging("Warnung - cd.cfg hat mehr als 2000 Eintraege")
    End If

    If cdrom = 0 then 
        If BootFlag = 0 Then  
            Call logging("CD-Laufwerk AUSGESCHALTET fuer Benutzer " & Username)
            CdromDisabled = 1
        End If
    End If
    If cdrom = 1 then 
        If BootFlag = 0 Then  
            Call logging("CD-Laufwerk EINGESCHALTET fuer Benutzer " & Username)
            CdromDisabled = 0
        End If
    End If


    '***************************************************************************************************************************
    ' Floppy-Erlaubnis prfen
    '***************************************************************************************************************************
    floppy = 0
    for i = 0 to FloppyUsersCounter
        If Username = Trim(AllowedFloppyUsers(i)) then floppy = 1
    next

    If FloppyUsersCounter > 2000 Then
    	floppy = 0
    	Call logging("Warnung - floppy.cfg hat mehr als 2000 Eintraege")
    End If

    If floppy = 0 then 
        If BootFlag = 0 Then  
            Call logging("Diskettenlaufwerk AUSGESCHALTET fuer Benutzer " & Username)
        End If
    End If
    If floppy = 1 then 
        If BootFlag = 0 Then  
            Call logging("Diskettenlaufwerk EINGESCHALTET fuer Benutzer " & Username)
        End If
    End If


    '***************************************************************************************************************************
    ' Floppy, CD-Laufwerke und USB-Gerte ein/ausschalten
    '***************************************************************************************************************************
    devcondisable = Chr(34) & ProgramPath & "\devcon.exe" & Chr(34) & " disable" 
    If floppy = 0 Then devcondisable = devcondisable + " FDC\*"
    If cdrom = 0 Then devcondisable = devcondisable + " IDE\CdRom*"
    If UsbMustBeDisabled = 1 Then
    	devcondisable = devcondisable + " USB\*"
        BootFlag = 0
        DevicesEnabled = 1 ' Einschalten von "0 Gert(en)..." verhindern
    End If
    If BootFlag = 0 Then
        If floppy = 0 or cdrom = 0 or UsbMustBeDisabled = 1 Then
            If loglevel = 3 Then Call logging("Starte DevconDisable fuer Benutzer " & Username  & " => " & devcondisable)
            Return = shell.Run(devcondisable, 0, True)
        End If
    End If

    devconenable = Chr(34) & ProgramPath & "\devcon.exe" & Chr(34) & " enable"
    If floppy = 1 Then devconenable = devconenable + " FDC\*"
    If cdrom = 1 Then devconenable = devconenable + " IDE\CdRom*"
    If UsbMustBeEnabled = 1 Then 
    	devconenable = devconenable + " USB\*"
        DevicesEnabled = 1 ' Einschalten von "0 Gert(en)..." verhindern  
    End If


    If SecondEnable > 0 Then
    	SecondEnable = SecondEnable - 1
    	If SecondEnable = 1 Then
            If loglevel = 3 Then Call logging("Starte DevconEnable (zweiter) fuer Benutzer " & Username & " => " & rememberenable)
            Return = shell.Run(rememberenable, 0, True)    	    	  
    	End If
    End if
    If BootFlag = 0 Then  
        If floppy = 1 or cdrom = 1 or UsbMustBeEnabled = 1 Then
            If loglevel = 3 Then Call logging("Starte DevconEnable (erster) fuer Benutzer " & Username  & " => " & devconenable)
            Return = shell.Run(devconenable, 0, True)
            SecondEnable = 3
            rememberenable = devconenable ' String merken
        End If
    End If
    
    ' USB-Gerte einschalten
    If DevicesEnabled = 0 Then
      devconenable = Chr(34) & ProgramPath & "\devcon.exe" & Chr(34) & " enable" 
      DevicesEnabled = 1
      Call logging(enable_counter & " USB-Geraet(e) eingeschaltet...") 
      For i = 0 to enable_counter - 1
        pos = InStr(UsbEnableList(i),"&")
        If pos > 0 Then
          EnableDevice = Left(UsbEnableList(i),pos-1) & Chr(34) & "&" & Chr(34) & Right(UsbEnableList(i), Len(UsbEnableList(i)) - pos)
        Else 
          EnableDevice = UsbEnableList(i)
        End If
        devconenable = devconenable & " USB\" & EnableDevice
        Call logging("USB-Geraet EINGESCHALTET fuer Benutzer " & Username & " - erlaubtes USB-Geraet: " & UsbEnableListDescription(i) & ": " & UsbEnableList(i))        
      Next
      If loglevel = 3 Then Call logging("Starte DevconEnable (erster) fuer Benutzer " & Username & " => " & devconenable)
      Return = shell.Run(devconenable, 0, True)
      SecondEnable = 3
      rememberenable = devconenable ' String merken

    End If
    


    '***************************************************************************************************************************
    ' Check, ob die Deaktivierung von USB-Gerten, Floppy and CD-Laufwerken funktioniert hat (CheckForBandits) 
    '***************************************************************************************************************************
    ' Reboot nur wenn ViolationShutdown = 1
    If CheckForBandits = 1 Then
        ' Floppy
        If floppy = 0 Then ' Floppy sollte ausgeschaltet sein 
            If loglevel = 3 Then Call logging("CheckForBandits (Floppy)")
	    For Each drive in oDrives
	        If drive.DriveLetter = "A" or drive.DriveLetter = "B" Then
  	            If drive.DriveType = 1 Then ' Floppy
	              Call logging("Shutdown wg. nicht deaktivierbarem Diskettenlaufwerk...")
                      If ViolationShutdown = 1 Then 
                        Return = shell.Run(Chr(34) & ProgramPath & "\shutdown.exe" & Chr(34) & " /T:1 /R /C", 0, True) ' W2K
                        Return = shell.Run(Chr(34) & ProgramPath & "\shutdown.exe" & Chr(34) & " -r -f -t 01", 0, True) ' XP
                      Else
                        Call logging("Shutdown notwendig wg. nicht deaktivierbarem Diskettenlaufwerk, jedoch verhindert von Konfigurationseinstellungen...")              
                      End If
	              Return = shell.Run("net send USBSecure-Console " & Chr(32) & "USBSecure: Abschaltung des Diskettenlaufwerks bei Benutzer " & UserName & " fehlgeschlagen!" & Chr(32), 0, False)
  	            End If
   	        End If
	    Next
        End If

        ' CD
        If cdrom = 0 Then ' CD-Laufwerk sollte ausgeschaltet sein
            If loglevel = 3 Then Call logging("CheckForBandits (CD)")
	    For Each drive in oDrives
	        If drive.DriveType = 4 Then ' CD
	            Call logging("Shutdown wg. nicht deaktivierbarem CD-Laufwerk")
                    If ViolationShutdown = 1 Then 
                        Return = shell.Run(Chr(34) & ProgramPath & "\shutdown.exe" & Chr(34) & " /T:1 /R /C", 0, True) ' W2K
                        Return = shell.Run(Chr(34) & ProgramPath & "\shutdown.exe" & Chr(34) & " -r -f -t 01", 0, True) ' XP
                    Else
                      Call logging("Shutdown notwendig wg. nicht deaktivierbarem CD-Laufwerk, jedoch verhindert von Konfigurationseinstellungen...")              
                    End If
                    Return = shell.Run("net send USBSecure-Console " & Chr(32) & "USBSecure: Abschaltung des CD-Laufwerks bei Benutzer " & UserName & " fehlgeschlagen!" & Chr(32), 0, False)
	        End If
	    Next
        End If
    End If

    ' USB 
    ' Check, ob ein USB-Gert luft, das nicht in der usb.cfg enthalten ist. Falls ja => Reboot
    If CheckForBandits = 1 and EverythingAllowed = 0 Then  
      If loglevel = 3 Then Call logging("CheckForBandits (USB)")
      For i = 0 to UsbDevicesCount - 1
        link = 0
        link = Shell.RegRead("HKLM\SYSTEM\CurrentControlSet\Control\DeviceClasses\" & a5 & "\##?#USB#" & RegistryString(i) & "\Linked")
        If link = 1 Then 
          UsbBandits = 1
          pos1 = InStr(RegistryString(i),"#")
          For y = 0 To AllowedDeviceCounter - 1
            pos2 = InStr(AllowedUsbDevices(y),":")
            If Left(RegistryString(i),pos1-1) = Mid(AllowedUsbDevices(y),pos2+2) Then
              UsbBandits = 0
            End If	
          Next
          If UsbBandits = 1 Then
            Call logging("Shutdown wg. nicht deaktivierbarem USB-Geraet")
            If ViolationShutdown = 1 Then 
              Return = shell.Run(Chr(34) & ProgramPath & "\shutdown.exe" & Chr(34) & " /T:1 /R /C", 0, True) ' W2K
              Return = shell.Run(Chr(34) & ProgramPath & "\shutdown.exe" & Chr(34) & " -r -f -t 01", 0, True) ' XP
            Else
              Call logging("Shutdown notwendig wg. nicht deaktivierbarem USB-Geraet, jedoch verhindert von Konfigurationseinstellungen...")              
            End If
            Return = shell.Run("net send USBSecure-Console " & Chr(32) & "USBSecure: Abschaltung des Diskettenlaufwerks bei Benutzer " & UserName & " fehlgeschlagen!" & Chr(32), 0, False)
          End If
        End If
      Next 
    End If
        
    If logdevices = 1 and readerror = 0 Then
      logdevices = 0
      If loglevel > 1 Then Call DeviceLogging() 
    End If
    
    ' CheckForBandits-Timer herabsetzen
    If CheckForBandits > 0 Then
        CheckForBandits = CheckForBandits - 1
    End If

    ScriptCounter = ScriptCounter + 1
    readerror = 0
    
    ' BootFlag auf 1 setzen, so dass keine Initialisierung mehr stattfindet (Konfigurationsdateien kopieren etc.)
    BootFlag = 1   

    ' 2 Sekunden Pause
    WScript.Sleep 2000 

Loop



'***************************************************************************************************************************
' Logfile USBSecure.log schreiben
'***************************************************************************************************************************
Sub logging(logtext)
    LogFile.writeline Date & " " & Time & "   " & logtext
End Sub

'***************************************************************************************************************************
' Text zum Logbuffer hinzufgen wg. Performance
'***************************************************************************************************************************
Sub AddLogbuffer(buffertext)
    Logbuffer(BufferCounter) = buffertext
    BufferCounter = BufferCounter + 1
End Sub

'***************************************************************************************************************************
' Logbuffer ins Logfile schreiben
'***************************************************************************************************************************
Sub WriteLogbuffer()
    For i = 0 to BufferCounter - 1
      LogFile.writeline Date & " " & Time & "   " & Logbuffer(i)
    Next
End Sub

'***************************************************************************************************************************
' Installierte/erlaubte USB-Gerte loggen
'***************************************************************************************************************************
Sub DeviceLogging()
    If loglevel > 1 Then
      Call logging("Anzahl installierter USB-Geraete in Registry: " & DeviceTypeCounter)
      For i = 0 to DeviceTypeCounter - 1
        Call logging(i + 1 & ". " & ExistingRegDevices(i))
      Next    
    End If
    If loglevel = 3 Then
      Call logging("Anzahl erlaubter USB-Geraete fuer Benutzer " & UserName & ": " & AllowedDeviceCounter)
        For i = 0 to AllowedDeviceCounter - 1
        Call logging(i + 1 & ". " & AllowedUsbDevices(i))
      Next 
    End If

End Sub

'***************************************************************************************************************************
' USBSecure.ini einlesen
'***************************************************************************************************************************
Sub ReadUSBSecureIni()
      loglevel = 1
      ViolationShutdown = 1
      Do While Not IniFile.AtEndOfStream
        zeile = IniFile.ReadLine
        pos = InStr(zeile,"=")
        If pos > 1 Then

          If LCase(Trim(Left(zeile,6))) = "server" Then 
            server = Trim(Mid(zeile,pos+1))
          End If

          If LCase(Trim(Left(zeile,8))) = "loglevel" Then 
            temp = LCase(Trim(Mid(zeile,pos+1)))
            If temp = "full" Then loglevel = 2
            If temp = "debug" Then loglevel = 3
          End If

 
          If LCase(Trim(Left(zeile,17))) = "violationshutdown" Then 
            temp = LCase(Trim(Mid(zeile,pos+1)))
            If temp = "no" Then ViolationShutdown = 0
          End If

        End If
      Loop
    IniFile.Close    
End Sub
