/*
 * PDFKonverter.java
 *
 * Created on 3. Januar 2006, 13:08
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package pdf;

import javax.swing.JOptionPane;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.UnoUrlResolver;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.task.PasswordRequestMode;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;



/**
 *
 * @author Administrator
 */
public class PDFKonverter {
    XComponent xComponent = null;
    PropertyValue[] aPDFFilterProperties = null;
    PropertyValue[] aOpenProperties = null;
    XComponentLoader xComponentLoader = null;
    XMultiServiceFactory xMSF = null;
    XSimpleFileAccess xSimpleFileAccess = null;
    static XComponentContext xOfficeComponentContext = null;
    static boolean bconnectviaPipe = false;
    /**
     * Creates a new instance of PDFKonverter
     */
    public PDFKonverter() {
    try{
        Object oSimpleFileAccess = xMSF.createInstance("com.sun.star.ucb.SimpleFileAccess");
        xSimpleFileAccess = (XSimpleFileAccess) UnoRuntime.queryInterface(XSimpleFileAccess.class, oSimpleFileAccess);      
    }
    catch(Exception exception){
        exception.printStackTrace(System.out);
    }}
    
    
    
     /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
    try {
        boolean bConnectionfailed = getRemoteConnection(args);
        if ((xOfficeComponentContext == null) && (bConnectionfailed)) {
            xOfficeComponentContext = com.sun.star.comp.helper.Bootstrap.bootstrap();
            if (xOfficeComponentContext == null){
                JOptionPane.showMessageDialog(new javax.swing.JFrame(), "Es konnte keine Verbindung zur Office-Applikation hergestellt werden!", "PDF-Konverter", JOptionPane.ERROR_MESSAGE);            
            }
            else{
                bconnectviaPipe = true;
            }
        }
        if( xOfficeComponentContext != null ){
           System.out.println("Verbindung zu einem laufenden Office wird hergestellt...");
            java.awt.EventQueue.invokeLater(new Runnable() {
                public void run() {
                    PDFDialog oPDFDialog = new PDFDialog(new javax.swing.JFrame(), true, xOfficeComponentContext, bconnectviaPipe);
                    // Die folgende Methode 'setLocationByPlatform' wird nicht von Java 1.4ff untersttzt
                    // PDFDialog.setLocationByPlatform(true);    
                    oPDFDialog.setLocation(100,100);
                    oPDFDialog.setVisible(true);
                }
            });
        }
        else{
            System.exit(0);            
        }
    }
    catch(Exception exception){
        exception.printStackTrace(System.out);
    }

}
         
        
    public static boolean getRemoteConnection(String[] _sargs){
    try{
        String sHostName = "";
        String sPortNumber = "";
        if (_sargs == null){
            return true;
        }
        for (int i = 0; i <_sargs.length; i++){
             String[] sDetailList = _sargs[i].split("=");
             if (sDetailList.length == 2){                 
                 String sConnectionDetail = sDetailList[0];
                 if (sConnectionDetail.equalsIgnoreCase("host")){
                    sHostName = sDetailList[1];
                 }
                 else if (sConnectionDetail.equalsIgnoreCase("Port")){
                     sPortNumber = sDetailList[1];
                 }
             }
        }
        if ((!sHostName.equals("")) && (!sPortNumber.equals(""))){
            String sConnection = "uno:socket,host=" + sHostName + ",port=" + sPortNumber + ";urp;StarOffice.ServiceManager";
            XComponentContext xcomponentcontext = Bootstrap.createInitialComponentContext(null);
            // create a connector, so that it can contact the office
            XUnoUrlResolver urlResolver = UnoUrlResolver.create(xcomponentcontext);
            Object initialObject = urlResolver.resolve(sConnection);
            XMultiComponentFactory xOfficeFactory = (XMultiComponentFactory) UnoRuntime.queryInterface(
            XMultiComponentFactory.class, initialObject);
            XPropertySet xProperySet = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, xOfficeFactory);
            // Get the default context from the office server.
            Object oDefaultContext = xProperySet.getPropertyValue("DefaultContext");
            // Query for the interface XComponentContext.
            xOfficeComponentContext = (XComponentContext) UnoRuntime.queryInterface(XComponentContext.class, oDefaultContext);
        }
        return true;
    }catch(Exception exception){
        JOptionPane.showMessageDialog(new javax.swing.JFrame(), "Es konnte keine Verbindung zum Office-Server hergestellt werden!", "PDF-Konverter", JOptionPane.ERROR_MESSAGE);
        exception.printStackTrace(System.out);
        return false;
    }}
     
} 



