using System;
namespace BewegtesObjekt
{
    class Program
    {
        static void Main(string[] args)
        {
            // Initialisierung
            Console.Title = "Abbruch mit ESC";
            Console.SetWindowSize(80, 30);
            Console.BufferHeight = 30;

            string[] ball1 = new string[] { " xxx ",
                                            "xxxxx",
                                            "xxxxx",
                                            " xxx "};
            string[] ball2 = new string[4];
            for (int i = 0; i < ball2.Length; i++)
                ball2[i] = new string('*', i + 1);

            // Testcode fr die drei im Text vorgestellten Klassen
            MovingObject mo = new MovingObject();
            mo.Speed = new vektor2D(1.5f, 1);
            MovingObject mo1 = new MovingArray(ball1, new vektor2D(1, 1), new vektor2D(30, 1));
            MovingObject mo2 = new MovingGravArray(ball1, new vektor2D(-1, 1.3f), new vektor2D(60, 1));


            // Testcode fr Aufgabe 2
            // MovingObject mo3 = new MovingColorGravArray(ball2, new vektor2D(-1.4f, 1), new vektor2D(20, 1), ConsoleColor.Red);

            // Testcode fr Aufgabe 3
            // MovingObject m = new MovingObject(); 
            // m.Speed = new vektor2D(0.5f, 1);
            // m.Position = new vektor2D(20, 1);
            // m.ball = '@';
            // MovingObject mo4 = new ColorMovingObject(m, ConsoleColor.Green);

            // Fensterbegrenzungen
            vektor2D topleft = new vektor2D(0, 0);
            vektor2D bottomright = new vektor2D((float)Console.WindowWidth, (float)Console.WindowHeight);

            // Animationsschleife
            while (true)
            {
                System.Threading.Thread.Sleep(50);
                mo.Animate(topleft, bottomright);
                mo1.Animate(topleft, bottomright);
                mo2.Animate(topleft, bottomright);
                // mo3.Animate(topleft, bottomright);
                // mo4.Animate(topleft, bottomright);
                if (Console.KeyAvailable)
                    if (Console.ReadKey().Key == ConsoleKey.Escape)
                        return;
            }
        }
        class MovingObject
        {
            public vektor2D Position = new vektor2D(0, 0); // Punkt oben links
            public vektor2D Speed = new vektor2D(0, 0);   // Geschwindigkeit
            public char ball = 'x';
            public virtual void Animate(vektor2D topleft, vektor2D bottomright)
            {
                Draw(true);
                Collision(topleft, bottomright);
                Position += Speed;
                Draw(false);
            }
            protected void Collision(vektor2D topleft, vektor2D bottomright)
            {
                if (Position.X + Speed.X < topleft.X || Position.X + Speed.X >= bottomright.X)
                    Speed.X = -Speed.X;
                if (Position.Y + Speed.Y < topleft.Y || Position.Y + Speed.Y >= bottomright.Y) Speed.Y = -Speed.Y;
            }

            protected virtual void Draw(bool erase)
            {
                int x = (int)Position.X;
                int y = (int)Position.Y;
                Console.SetCursorPosition(x, y);
                Console.Write(erase ? ' ' : ball);
            }
        }
        class MovingArray : MovingObject
        {
            public new string[] ball = new string[] { "x" };
            public MovingArray(string[] b, vektor2D v, vektor2D pos)
            {
                ball = b; Speed = v; Position = pos;
            }
            public override void Animate(vektor2D topleft, vektor2D bottomright)
            {
                int horlen = ball[0].Length;
                foreach (string s in ball)
                    if (s.Length > horlen)
                        horlen = s.Length;
                base.Animate(topleft, new vektor2D(bottomright.X - horlen + 1, bottomright.Y - ball.Length + 1));
            }

            protected override void Draw(bool erase)
            {
                int x = (int)Position.X;
                int y = (int)Position.Y;
                foreach (string s in ball)
                {
                    Console.SetCursorPosition(x, y++);
                    Console.Write(erase ? new string(' ', s.Length) : s);
                }
            }
        }

        class MovingGravArray : MovingArray
        {
            vektor2D v;
            public MovingGravArray(string[] ball, vektor2D v, vektor2D pos)
                : base(ball, v, pos)
            {
                this.v = new vektor2D(v.X, v.Y);
            }
            public override void Animate(vektor2D topleft, vektor2D bottomright)
            {
                if (Speed.Y >= 0)
                    Speed.Y = v.Y * (Position.Y + 2) / 10;
                else
                    Speed.Y = -v.Y * (Position.Y + 2) / 10;
                base.Animate(topleft, bottomright);
            }
        }
        class vektor2D
        {
            public float X, Y;
            public vektor2D(float x, float y)
            { X = x; Y = y; }
            public static vektor2D operator +(vektor2D a, vektor2D b)
            { return new vektor2D(a.X + b.X, a.Y + b.Y); }
        }
    }
}
