package hibernate.ct.beispiele;

import hibernate.ct.Angestellter;
import hibernate.ct.FreierMitarbeiter;
import hibernate.ct.Kunde;
import hibernate.ct.Mitarbeiter;
import hibernate.ct.Projekt;

import java.util.Iterator;

import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;

public class Beispiel_HQL {

	public static void main(String[] args) throws Exception {
		Configuration configuration = new net.sf.hibernate.cfg.Configuration();
		configuration.addFile("Mapping.hbm.xml");
		SessionFactory factory = configuration.buildSessionFactory();
		Session session = factory.openSession();
		try {

			// Speichern von Beispieldaten
			FreierMitarbeiter freierMitarbeiter = new FreierMitarbeiter(
					"Mller", "Manfred");
			session.save(freierMitarbeiter);

			Angestellter angestellter = new Angestellter("Meier", "Michael");
			session.save(angestellter);

			Projekt p1 = new Projekt("Projekt 1");
			session.save(p1);

			Projekt p2 = new Projekt("Projekt 2");
			session.save(p2);

			Projekt p3 = new Projekt("Projekt 3");
			session.save(p3);

			Kunde k = new Kunde("Kunde 1");
			session.save(k);

			p3.setKunde(k);

			angestellter.getProjektbeteiligungen().add(p1);
			angestellter.getProjektbeteiligungen().add(p3);

			session.flush();

			// Verwendung der im Mapping-File definierten 
			// Abfrage mit dem Namen "ProjektNamenNachMitarbeiterNachname"
			Query query = session
					.getNamedQuery("ProjektNamenNachMitarbeiterNachname");
			
			// Der Parameter ":nachname" wird gesetzt
			query.setString("nachname", angestellter.getNachname());
			
			// Abfrage und Ausgabe
			for (Iterator iter = query.list().iterator(); iter.hasNext();) {
				String p = (String) iter.next();
				System.out.println("Zugerdnetes Projekt: " + p);
			}

			// Verwendung der im Mapping-File definierten 
			// Abfrage mit dem Namen "MitarbeiterNachKundenbezeichnung"
			query = session.getNamedQuery("MitarbeiterNachKundenbezeichnung");

			// Der Parameter ":kundenbezeichnung" wird gesetzt
			query.setString("kundenbezeichnung", "Kunde 1");

			// Abfrage und Ausgabe
			for (Iterator iter = query.list().iterator(); iter.hasNext();) {
				Mitarbeiter m = (Mitarbeiter) iter.next();
				System.out.println("Projekten vom 'Kunde 1' zugewiesen: "
						+ m.getNachname() + ", " + m.getVorname());
			}

		} finally {
			session.close();
			factory.close();
		}
	}
}
