/*
 * Created on 05.02.2006
 */
package hibernate.ct.beispiele;

import hibernate.ct.Mitarbeiter;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;

public class Beispiel_ObjektSpeichern {

	public static void main(String[] args) throws Exception {
		Configuration configuration = new net.sf.hibernate.cfg.Configuration();
		configuration.addFile("Mapping.hbm.xml");
		SessionFactory factory = configuration.buildSessionFactory();
		Session session = factory.openSession();
		try {
			Mitarbeiter mitarbeiter = new Mitarbeiter("Mller", "Manfred");
			session.save(mitarbeiter);
			session.flush();

			long idVomGespeichertenObjekt = mitarbeiter.getId();
			
			// Auslesen des Mitarbeiters anhand seiner ID
			Mitarbeiter m = (Mitarbeiter) session.get(Mitarbeiter.class, Long
					.valueOf(idVomGespeichertenObjekt));
			
			// Ausgabe
			System.out.println("Mitarbeiter: " + m.getNachname() + ", "
					+ m.getVorname());

		} finally {
			session.close();
			factory.close();
		}
	}
}
