/* $Id: CoClassFactory.cpp 784 2006-05-03 11:48:41Z olau $ */

// Copyright (c) 2006 Caspar Gorvin, http://www.gorvin.de/
// Copyright (c) 2006 Heise Zeitschriften Verlag, http://www.heise.de/
// All rights reserved.

#include "stdafx.h"
#include "CoClassFactory.h"
#include "CoStreamColumns.h"
#include "ObjectCounter.h"


CoClassFactory::CoClassFactory(void)
: m_nRefCount(0)
{
	IncrementObjectCounter();
}

CoClassFactory::~CoClassFactory(void)
{
	DecrementObjectCounter();
}

// *****************************************************************
// Implementierung des Interface IUnknown
// *****************************************************************

STDMETHODIMP CoClassFactory::QueryInterface(REFIID riid, void** ppvObject)
{
	if (riid == IID_IUnknown) 
		*ppvObject = (IUnknown *) this;
	else if (riid == IID_IClassFactory) 
		*ppvObject = (IClassFactory *) this;
	else 
	{
		*ppvObject = NULL;
		return E_NOINTERFACE;
	}
	AddRef();
	return S_OK;
}

STDMETHODIMP_(ULONG) CoClassFactory::AddRef()
{
	return ++m_nRefCount;
}

STDMETHODIMP_(ULONG) CoClassFactory::Release()
{
	if (--m_nRefCount)
		return m_nRefCount;
	delete this;
	return 0;
}

// *****************************************************************
// Implementierung des Interface IClassFactory
// *****************************************************************

STDMETHODIMP CoClassFactory::CreateInstance(LPUNKNOWN pUnkOuter, 
                                            REFIID riid, 
                                            void** ppvObject)
{
	// Diese Klasse untersttzt keine Aggregation
	if (pUnkOuter)
		return CLASS_E_NOAGGREGATION;

	// Erzeugen einer neuen Instanz der COM-Klasse CoStreamColumns
	CoStreamColumns* pInstance = new CoStreamColumns();
	if (!pInstance)
		return E_OUTOFMEMORY;

	// Erfragen des gewnschten Interface-Pointers auf die
	// neu erzeugte Instanz
	HRESULT hr = pInstance->QueryInterface(riid, ppvObject);
	if (FAILED(hr))
		delete pInstance;

	return hr;
}

STDMETHODIMP CoClassFactory::LockServer(BOOL fLock)
{
	if (fLock)
		IncrementObjectCounter();
  else
    DecrementObjectCounter();
	return S_OK;
}








