# $Id: Makefile.mak 860 2006-07-07 07:39:00Z olau $

outdir = Release
pthreadsinc = C:\pthreads\include
pthreadslib = C:\pthreads\lib

#######################################################################
# Einstellungen fr C++-Compiler aus Visual Studio 8
#######################################################################
#cc = cl
#link = link
#cdebug = /DDEBUG /Zi
#cflags = /TC /Ox /openmp /DWIN32 /GL /FD /EHsc /W3 /Wp64 /MD /fp:precise /errorReport:prompt
#conflags = /LTCG

#######################################################################
# Einstellungen fr Intel C++-Compiler 9.x
#######################################################################
cc = icl
link = xilink
cdebug = /DDEBUG 
cflags = /O3 /QxP /Qopenmp /MD /fp:precise /DWIN32 /W3 /Wp64
conflags = /MACHINE:x86 /LIBPATH:"C:\Programme\VS2005Pro\VC\redist\x86"



all: $(outdir)\pi.exe \
	$(outdir)\openmp0.exe \
	$(outdir)\openmp1.exe \
	$(outdir)\openmp2.exe \
	$(outdir)\openmp3.exe \
	$(outdir)\openmp-timer.exe \
	$(outdir)\pi-openmp.exe \
	$(outdir)\pi-wthreads.exe \
	$(outdir)\pi-pthreads.exe \
	$(outdir)\pi-bbp.exe \
	$(outdir)\pi-bbp-openmp.exe \
	$(outdir)\pi-bbp-openmp2.exe \
	$(outdir)\pi-bbp-openmp3.exe \
#	$(outdir)\pi-openmp-illegal.exe \

.c.obj:
	$(cc) /c $(cdebug) $(cflags) $(cvarsmt) $*.c

$(outdir)\pi.exe: pi.obj ompdefs.h timer.obj
	$(link) $(ldebug) $(conflags) /out:$(outdir)\pi.exe pi.obj timer.obj $(conlibs)

$(outdir)\openmp0.exe: openmp0.obj ompdefs.h
	$(link) $(ldebug) $(conflags) /out:$(outdir)\openmp0.exe openmp0.obj $(conlibs)

$(outdir)\openmp1.exe: openmp1.obj ompdefs.h
	$(link) $(ldebug) $(conflags) /out:$(outdir)\openmp1.exe openmp1.obj $(conlibs)

$(outdir)\openmp2.exe: openmp2.obj ompdefs.h
	$(link) $(ldebug) $(conflags) /out:$(outdir)\openmp2.exe openmp2.obj $(conlibs)

$(outdir)\openmp3.exe: openmp3.obj ompdefs.h
	$(link) $(ldebug) $(conflags) /out:$(outdir)\openmp3.exe openmp3.obj $(conlibs)

$(outdir)\openmp-timer.exe: openmp-timer.obj ompdefs.h timer.obj
	$(link) $(ldebug) $(conflags) /out:$(outdir)\openmp-timer.exe openmp-timer.obj timer.obj $(conlibs)

$(outdir)\pi-openmp.exe: pi-openmp.obj ompdefs.h globaldefs.h getopt.obj 
	$(link) $(ldebug) $(conflags) /out:$(outdir)\pi-openmp.exe pi-openmp.obj $(conlibs)

$(outdir)\pi-openmp-illegal.exe: pi-openmp-illegal.obj ompdefs.h globaldefs.h
	$(link) $(ldebug) $(conflags) /out:$(outdir)\pi-openmp-illegal.exe pi-openmp-illegal.obj $(conlibs)

$(outdir)\pi-bbp.exe: pi-bbp.obj ompdefs.h globaldefs.h getopt.obj timer.obj
	$(link) $(ldebug) $(conflags) /out:$(outdir)\pi-bbp.exe pi-bbp.obj getopt.obj timer.obj $(conlibs)

$(outdir)\pi-bbp-openmp.exe: pi-bbp-openmp.obj ompdefs.h globaldefs.h getopt.obj 
	$(link) $(ldebug) $(conflags) /out:$(outdir)\pi-bbp-openmp.exe pi-bbp-openmp.obj getopt.obj $(conlibs)

$(outdir)\pi-bbp-openmp2.exe: pi-bbp-openmp2.obj ompdefs.h globaldefs.h getopt.obj 
	$(link) $(ldebug) $(conflags) /out:$(outdir)\pi-bbp-openmp2.exe pi-bbp-openmp2.obj getopt.obj $(conlibs)

$(outdir)\pi-bbp-openmp3.exe: pi-bbp-openmp3.obj ompdefs.h globaldefs.h getopt.obj 
	$(link) $(ldebug) $(conflags) /out:$(outdir)\pi-bbp-openmp3.exe pi-bbp-openmp3.obj getopt.obj $(conlibs)

$(outdir)\pi-wthreads.exe: pi-wthreads.obj ompdefs.h globaldefs.h getopt.obj timer.obj
	$(link) $(ldebug) $(conflags) /out:$(outdir)\pi-wthreads.exe pi-wthreads.obj getopt.obj timer.obj $(conlibs)

$(outdir)\pi-pthreads.exe: pi-pthreads.obj ompdefs.h globaldefs.h getopt.obj timer.obj
	$(link) $(ldebug) $(conflags) /LIBPATH:$(pthreadslib) /out:$(outdir)\pi-pthreads.exe pi-pthreads.obj getopt.obj timer.obj $(conlibs) pthreadVC2.lib

pi-pthreads.obj:
	$(cc) /c $(cdebug) $(cflags) $(cvars) /I$(pthreadsinc) pi-pthreads.c

getopt\getopt.lib: getopt.obj
	$(link) /DLL $(ldebug) $(conflags) /out:getopt\getopt.lib getopt.obj $(conlibs)

getopt.obj:
	$(cc) /c $(cdebug) $(cflags) $(cvars) getopt\getopt.c

timer\timer.lib: timer.obj
	$(link) /DLL $(ldebug) $(conflags) /out:timer\timer.lib timer.obj $(conlibs)

timer.obj:
	$(cc) /c $(cdebug) $(cflags) $(cvars) timer\timer.c

clean:
	del $(outdir)\*.exe
	del $(outdir)\*.manifest
	del *.obj
	del *.lib
	del *.idb
	del *.pdb
