/* $Id: pi.c 826 2006-06-12 09:05:16Z olau $ */

#include <stdio.h>
#include "globaldefs.h"
#include "timer/timer.h"

int main(int argc, char *argv[]) {
  int i;
  double w, x, sum, pi;
  LONGLONG duration;

  START();
  w = 1.0 / DEFAULT_ITERATIONS;
  sum = 0;
  for (i = 1; i <= DEFAULT_ITERATIONS; i++) {
    x = w * ((double) i - 0.5);
    sum += f(x); /* f(x) = 4/(1+x^2) */
  }
  pi = w * sum;
  STOP(duration);
  printf("pi = %.13lf (Fehler: %.13lf)\n", pi, pi - PI);
  printf("Ausfuehrungsdauer: %lld ms\n\n", duration / 1000LL);
  return 0;
}
