#!/usr/bin/perl -w

use strict;
use threads;

$| = 1; # Autoflush einschalten.

sub SIGTERM_handler {
    print "TERMhandler\n";
}

sub SIGKILL_handler {
    print "KILLhandler\n";
    threads->exit();
}

sub aThread {
    my $i = 0;
    printf '%d ', $i++ and sleep 1 while(1);
}

$SIG{TERM} = \&SIGTERM_handler;
$SIG{KILL} = \&SIGKILL_handler;

my $thread = threads->new(\&aThread);
$thread->detach();

sleep 5;
$thread->kill('SIGTERM');
print "SIGTERM gesendet\n";

sleep 5;
$thread->kill('SIGKILL');
print "SIGKILL gesendet\n";

sleep 5;
