#!/usr/bin/perl -w
#
# Demonstration: Signale an Threads senden.
#
# Copyright (C) 2006 Heise Zeitschriften Verlag, Oliver Lau <ola@ctmagazin.de>
# Alle Rechte vorbehalten.
#
# $Id: signaling.pl 910 2006-07-13 07:36:36Z olau $

use strict;
use threads;
use threads::shared;

my $mutex : shared = 0;

sub aThread {
	print "Thread A wartet 2 Sekunden ...\n";
	sleep 2;
	{
		lock($mutex);
		print "Thread A wartet auf Thread B ...\n";
		cond_wait($mutex);
	}
	print "Thread A folgt Thread B ...\n";
}

sub bThread {
	print "Thread B wartet 4 Sekunden ...\n";
	sleep 4;
	print "Thread B holt Thread A ab ...\n";
	{
		lock($mutex);
		cond_signal($mutex);
	}
}


print "Thread A und B starten ...\n";
my $threadA = threads->new(\&aThread);
my $threadB = threads->new(\&bThread);

$threadA->join;
$threadB->join;
