unit apfelunit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, Menus,inifiles,apfelimage,apfelcommon,
  Mask;

type
  TForm1 = class(TForm)
    run: TButton;
    Memo1: TMemo;
    StatusBar2: TStatusBar;
    Button2: TButton;
    Button3: TButton;
    MainMenu1: TMainMenu;
    Datei1: TMenuItem;
    Beenden1: TMenuItem;
    N1: TMenuItem;
    Druckereinrichtung1: TMenuItem;
    Drucken1: TMenuItem;
    N2: TMenuItem;
    Speichernunter1: TMenuItem;
    Speichern1: TMenuItem;
    ffnen1: TMenuItem;
    Neu1: TMenuItem;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    Button4: TButton;
    Button5: TButton;
    eColourpar: TEdit;
    Button6: TButton;
    Button7: TButton;
    Iterationen: TLabeledEdit;
    exmax: TLabeledEdit;
    eymax: TLabeledEdit;
    eR0s: TLabeledEdit;
    eI0s: TLabeledEdit;
    ComboBox1: TComboBox;
    eZoom: TLabeledEdit;
    eThreads: TLabeledEdit;
    eGrenze: TLabeledEdit;
    cOpenMP: TCheckBox;
    Label1: TLabel;
    procedure runClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    Procedure SetParas;
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Speichern1Click(Sender: TObject);
    procedure Speichernunter1Click(Sender: TObject);
    procedure ffnen1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Change(Sender: TObject);
    Procedure SetRGBtab (c:integer);
    procedure NewImage (var msg:TMessage); message WM_User+0;
    procedure cOpenMPClick(Sender: TObject);
    { Private-Deklarationen }
  public
  aBitmap:TBitmap;
  changed:boolean;
  rootdir:string;
  inifile:Tinifile;
  inisections:TStringlist;

 { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  w:longword;
implementation



{$R *.dfm}
//function Line_Gen_D_C (const r0, i0, dr:double; xmax:integer; const g:double; maxiter:longword; pCount:PDWORD):int64; cdecl;
//         external 'apfeldll.dll' name 'Line_Gen_D_C';

type TApfel_Line_proc_D = function (const r0, i0, dr:double; xmax:integer; const g:double; maxiter:longword; pCount:PDWORD):int64; cdecl;
type TApfel_frame_proc_D =function (const r0, i0, dr,di:double;xmax,ymax,pDelta:integer;const g:Double;maxiter:longword;pCount:PDWORD):int64; cdecl;
type TApfel_OpenMP_proc_D=function (Line_proc:Tapfel_Line_proc_D;const r0, i0, dr,di:double;xmax,ymax,pDelta:integer;const g:Double;maxiter:longword;pCount:PDWORD):int64; cdecl;

type TApfelLimit=(cart,polar);
type TCPUUnit=(CPU,FPU,MMX,MMX2,K3D,K3D2,SSE, SSE2,SSE3,SSE4);
type Tinterface=(Pixel,Line,Frame,OpenMP_frame);
type TApfelMethod= record
      name:string;
      proc:PAnsiChar;
      Cpuunit:Tcpuunit;
      resolution:byte;
      Limittype:TApfellimit;
      inter:Tinterface;
      OpenMP:boolean;
      addr:pointer;
      end;

const Defaultmethod:TApfelMethod =

       (
       name:'Generic Delphi DP FPU';
       proc:'Line_Gen_Pix_D';
       CPUunit:FPU;
       Resolution:8;
       Limittype:polar;
       inter:Line;
       openMP:false;
       addr:nil;
       );

var OpenMPMethod:TApfelmethod;


type PTinfoblock=^Tinfoblock;

Tinfoblock= packed record   // Infoblock fr jeden Thread
 r0,i0,del,g:rtype; //32
 xmax,ymax:integer; //8
 aby,bisy:integer;  //8
 maxiter:integer;   //4
 ThreadID:Thandle;   //4
 Iterations:int64;   //8
 padding:array[0..63] of Byte;
end;

var infoblock:array[1..16] of Tinfoblock;
var ThreadHandle:array[1..16] of Thandle;

var Methods:array  of TApfelMethod;
var Apfel_line_proc_D:TApfel_line_proc_D;
var Apfel_frame_proc_D:TApfel_frame_proc_D;
var Apfel_OpenMP_proc_D:TApfel_OpenMP_proc_D;
var procnr:integer;
var Threads:integer;
var qa,qe,qs,qf:int64;
var sumiterations:Int64;

Function scanline32RGB(RGB:longword):longword;
begin
 result:=(RGB and $FF) shl 16 or ((RGB and $FF00) shl 8) or (RGB and $FF0000);
end;


Function Line_Gen_pix_D (const r0,i0,dr:rtype;xmax:integer;g:rtype;maxiter:longword; p:PDWORD):int64; cdecl;
var a,b,a2,b2:rtype;
var j:integer;
var count:longword;
var r,g2:rtype;
begin
g2:=g*g;
r:=r0;
result:=0;
for j:=1 to xmax do
 begin
 a:=0;b:=0;a2:=0;b2:=0;
 count:=0;
 repeat
 b:=a*b*2+i0;
 a:=a2-b2+r;
 a2:=a*a;
 b2:=b*b;
 inc (count);
 until (count >= maxiter) or (a2+b2 > G2);
 p^:= count;
 inc (p);
 r:=r+dr;
 inc (result,count);
 end;

end;

Procedure Gen_pix_D (r,i:rtype;var count:longword);
var a,b,a2,b2:rtype;

begin
 a:=0;b:=0;a2:=0;b2:=0;
 count:=0;
 repeat
 b:=a*b*2+i;
 a:=a2-b2+r;
 a2:=a*a;
 b2:=b*b;
 inc (count);
 until (count >= maxiter) or (a2+b2 > G2);
end;


Function Apfelthread (p:pointer): integer;
var y:integer;
begin
with ptinfoblock (p)^ do
 for y:=aby to bisy do
  Iterations:=Apfel_line_proc_D (r0,i0+y*del,del,xmax,g,maxiter,@ascreen[y*xmax]);
end;

Function FrameApfelproc (inter:Tinterface;openMP:boolean): int64;
var y:integer;
begin
 result:=0;
 case inter of
 Frame:result:=Apfel_frame_proc_D (r0,i0,del,del,xmax,ymax,1,g,maxiter,@ascreen[0]);
 Line:begin
      if  OpenMP then result:=Apfel_OpenMP_Proc_D(Apfel_line_proc_D,r0,i0,del,del,xmax,ymax,1,g,maxiter,@ascreen[0])
      else for y:=0 to ymax-1 do inc (result,Apfel_line_proc_D (r0,i0+y*del,del,xmax,g,maxiter,@ascreen[y*xmax]));
      end;
 end;
end;

Procedure copytoinfoblock (nr,ab,bis:integer);
begin
     infoblock[nr].aby:=ab;
     infoblock[nr].bisy:=bis;
     infoblock[nr].r0:=r0;
     infoblock[nr].i0:=i0;
     infoblock[nr].del:=del;
     infoblock[nr].g:=g;
     infoblock[nr].maxiter :=maxiter;
     infoblock[nr].xmax :=xmax;
     infoblock[nr].ymax :=ymax;
end;


procedure TForm1.newimage (var msg:Tmessage);
var x,y:integer;
var button:TMouseButton;
var shift:word;
begin
x:=msg.LParamLo;
y:=msg.LParamHi;
R0s:=r0+x*del;
I0s:=i0+y*del;

if msg.WParamLo <> 0 then del:=del/msg.WParamlo;
if msg.WParamhi <> 0 then del:=del*msg.WParamhi;
msg.result:=1;

rwidth:=del*xmax;
zoom:=1/del;
r0 :=R0s-xmax/2*del;
i0 :=I0s-ymax/2*del;

eI0s.Text:=Format('%20g',[I0s]);
eR0s.Text:=Format('%20g',[R0s]);
eZoom.Text:=Format ('%20g',[Zoom]);

changed:=false;
runClick(self);
end;



procedure TForm1.runClick(Sender: TObject);
var p:longword;
var T:thandle;
var TID:cardinal;
var i,j:integer;
var waitresult:cardinal;
var yl,linesprothread:integer;
begin

if changed  then
 begin
 xmax:=strtoint(exmax.Text);
 ymax:=strtoint(eymax.Text);
 maxiter:=strtoint(Iterationen.text);
 r0s:=strtofloat (eR0s.Text);
 i0s:=strtofloat (eI0s.Text);
 zoom:=strtofloat (eZoom.Text);
 G:=strtofloat(eGrenze.Text);
 setparas;
 Form2.setimage(xmax,ymax);
 changed:=false;
 end;
 Threads:=strtoint(ethreads.text);
 procnr:=combobox1.itemindex;
 case Methods[procnr].inter of
  Line:@Apfel_Line_proc_D:=Methods[procnr].addr;
  Frame:@Apfel_Frame_proc_D:=Methods[procnr].addr;
 end;
 Ethreads.enabled:= Methods[procnr].inter <>frame;
 if Methods[procnr].inter=frame then threads:=0;



 Form2.label1.Caption:=Floattostr(R0)+'|'+Floattostr(I0);
 Form2.label2.Caption:=Floattostr(R0+Xmax*del)+'|'+Floattostr(I0+Ymax*del);
 t:=0;
  Form2.visible:=true;

  Form2.BringToFront;
  queryperformancecounter(qs);
  try
  case threads of
  0: sumiterations:=Frameapfelproc(methods[procnr].inter,cOpenMP.checked);
  1: begin
     copytoinfoblock(1,0,ymax-1);
     with infoblock[1] do
      begin
      Threadhandle[1]:=Beginthread (nil,0,apfelthread,@infoblock[1],0,ThreadID);
      waitresult:= WaitForSingleObject(Threadhandle[1],INFINITE);
      sumiterations:=infoblock[1].iterations;
      end;
     memo1.lines.add (inttohex(Waitresult,8));
     end;
  else
     begin
     linesprothread:=8;
     yl:=0;
     for i:=1 to threads do
      begin
       if yl+linesprothread>ymax-1 then linesprothread:=ymax-1-yl;
       copytoinfoblock(i,yl,yl+linesprothread);
       yl:=yl+linesprothread+1;
       with infoblock[i] do Threadhandle[i]:=Beginthread (nil,0,apfelthread,@infoblock[i],0,threadID);
       end;

       repeat
       waitresult:= WaitForMultipleObjects(threads,@Threadhandle,false,INFINITE);

       if yl <ymax-1 then
        begin
         i:=waitresult+1;
         if yl+linesprothread>ymax-1 then linesprothread:=ymax-1-yl;
         copytoinfoblock(i,yl,yl+linesprothread);
         with infoblock[i] do Threadhandle[i]:=Beginthread (nil,0,apfelthread,@infoblock[i],0,threadID);
         yl:=yl+linesprothread+1;
         end
        else
           begin
           waitresult:= WaitForMultipleObjects(threads,@Threadhandle,true,INFINITE);
           sumiterations:=0;
           for j:=1 to threads do inc (sumiterations,infoblock[i].Iterations);
           break;
           end;

       until false;



     end;
  end;
  except
   memo1.Lines.Add('oops, da ist was schief gegangen');
   if T <> 0 then Closehandle (T);
   end;

 queryperformancecounter(qa);

  Form2.showscreen;
  queryperformancecounter(qe);
  Form1.memo1.lines.add(Format ('%6.3gs %6.2gs fr %d Iterationen => %g Iterations/s',[(qa-qs)/qf, (qe-qa)/qf,sumiterations, sumiterations*qf/(qa-qs)]));

end;


Procedure TForm1.SetParas;
var i:integer;
begin
Iterationen.Text:=inttostr(maxiter);
eXmax.Text:=inttostr(xmax);
eYmax.Text:=inttostr(ymax);
eI0s.Text:=Format('%20g',[I0s]);
eR0s.Text:=Format('%20g',[R0s]);
eZoom.Text:=Format ('%20g',[Zoom]);
eGrenze.Text:=Format ('%20g',[G]);
eThreads.Text:=inttostr(Threads);
eColourpar.Text:=inttostr(colourpara);
 del:=1/zoom;
 rwidth:=del*xmax;
 R0 :=R0s-xmax/2*del;
 I0 :=I0s-ymax/2*del;
SetLength(RGbtab,maxiter+2);
SetLength(ascreen,(ymax*xmax));
statusbar2.Panels[6].Text:=inttohex(Longword(@ascreen[0]),8);
//memo1.Lines.add ('screen='+inttohex(longword(@ascreen[0]),8)+'..'+inttohex(longword(@ascreen[ymax*xmax-1]),8));
setRGBtab(Colourscheme);
end;

Procedure TForm1.SetRGBtab (c:integer);
var i,r,w:integer;
begin
 colourscheme:=c;
 colourpara:=strtoint(eColourPar.text);
 case C of
 2:for i:=0 to maxiter do Rgbtab[i]:=trunc(random*$FFFFFF);
 4:for i:=0 to maxiter do
   begin
   w:=maxiter-i;
   case i mod 3 of
    0: RGBtab[w]:=((i div 3) and $FF);
    1: RGBtab[w]:=((i div 3) and $FF) shl 8;
    2: RGBtab[w]:=((i div 3) and $FF) shl 16;
   end;
  end;
 5:for i:=0 to maxiter do RGBtab[maxiter-i]:= trunc(i* colourpara);
 6:for i:=0 to maxiter do RGBtab[i]:= trunc((i div 256) * colourpara)+ i mod 256;
 7:
   begin
    for i:=0 to maxiter do
    begin
    w:=i mod 768;
    if odd (colourpara) then r:=maxiter-i else r:=i;
    if w < 256 then RGBtab[r]:=w
    else if w < 512 then RGBtab[r]:=(w-256) shl 8
     else if w < 768 then RGBtab [r]:=(w-512) shl 16;
    end;
   end;
 else  for i:=0 to maxiter do Rgbtab[i]:=scanline32RGB(colourpara*i and $FFFFFF);

 end;
end;


procedure TForm1.FormCreate(Sender: TObject);
var DLLhandle:Thandle;
var DLLName,LastDLLname,Funcname,proc:string;
var i,sec:integer;
var info:pointer;
var s:string;
begin
 memo1.Clear;
 inisections:=tStringlist.create;
 inisections.CaseSensitive:=false;
 rootdir:=extractfileDir(paramstr(0));
 IniFile := TIniFile.Create(rootdir+'\ctapfel.ini');
 IniFile.ReadSections(inisections);
 If inisections.Count=0
  then memo1.Lines.add ('Inifile ctapfel.ini nicht gefunden')
  else memo1.Lines.add ('Inifile ctapfel.ini gefunden');
 ThousandSeparator:=#0;
 if Inifile.Readstring('Default','Decimal',',')=','
 then DecimalSeparator:=',' else DecimalSeparator:='.';
 xmax:=IniFile.ReadInteger ('Default','xmax',640);
 ymax:=IniFile.ReadInteger ('Default','ymax',480);
 maxiter:=IniFile.ReadInteger ('Default','maxiter',256);
 g:=Inifile.ReadFloat   ('Default','g',4.0);
 Zoom:=Inifile.ReadFloat   ('Default','zoom',200);
 i0s:=Inifile.ReadFloat   ('Default','i0s',4.0);
 r0s:=Inifile.ReadFloat   ('Default','r0s',100);
 Threads:=Inifile.ReadInteger ('Default','Threads',0);
 Colourscheme:= Inifile.ReadInteger ('Default','Colourscheme',10);
del:=1/zoom;
Form1handle:=Form1.handle;
Setlength(Methods,1);
Methods[0]:=Defaultmethod;
Methods[0].addr:=@Line_Gen_pix_D;

i:=1;
LastDLLName:='';
for sec:=0 to Inisections.count-1 do
 if Copy (Inisections.strings[sec],1,4)='PROC' then
 begin
 proc:= Inisections.strings[sec];
 DLLName:=Inifile.ReadString(proc,'DLLname','');
 if (DLLName <>'') and (DLLName <> LastDLLName) then DLLhandle:=LoadLibrary (Pchar(DLLName));
 if DLLhandle<>0 then
   begin
   funcname:=IniFile.Readstring(proc,'func','');
   if funcname <>'' then
    begin
    Setlength(Methods,i+1);
    memo1.lines.add (dllname+':'+funcname);
    Methods[i]:=Defaultmethod;
    s:=uppercase(IniFile.ReadString(proc,'inter','LINE'));
   with Methods[i] do if s='PIXEL' then inter:=pixel else if s='LINE' then inter:=line
     else if s='FRAME' then inter:=frame else if s='OPENMP_FRAME' then inter:=OPENMP_FRAME;

    Methods[i].addr:=Getprocaddress(Dllhandle,pchar(funcname));
    Methods[i].name:=IniFile.ReadString(proc,'name',funcname);
    Methods[i].proc:=pchar(funcname);
    Methods[i].OpenMP:=IniFile.ReadBool(proc,'OpenMP',false);
    if  Methods[i].inter=OpenMP_Frame then
     begin
     cOpenMP.enabled:=true;
     OpenMPmethod:=Methods[i];
     Apfel_OpenMP_proc_D:=OpenMPMethod.addr;
     end
    else
    if (Methods[i].addr <> nil) then
     begin
     Combobox1.Items.Add(methods[i].name);
     inc (i);
     end;
    end;
   end;
 end;

if i=1 then memo1.lines.add ('keine DLL-Funktionen gefunden, nur generic Delphi-Lsung mglich');
SetParas;
changed:=false;
queryperformancefrequency(qf);
end;



procedure TForm1.Speichern1Click(Sender: TObject);
begin
Form2.image1.Picture.Bitmap.SaveToFile('apfel.bmp');
end;


procedure TForm1.Speichernunter1Click(Sender: TObject);
var info:infoblk;
var aFile:File;
var res:integer;
var y:integer;
begin
if savedialog1.execute then
 begin
 if uppercase(Extractfileext (savedialog1.FileName))='.BMP' then Form2.image1.Picture.Bitmap.SaveToFile(savedialog1.filename)
 else
  begin
  assignFile (aFile,savedialog1.FileName);
  rewrite (aFile,1);
  info.xmax:=xmax;
  info.ymax:=ymax;
  info.parasize:=sizeof (rtype);
  info.r0s:=r0s;
  info.i0s:=i0s;
  info.rwidth:=rwidth;
  info.g:=g;
  info.maxiter:=maxiter;
  info.colourscheme:=colourscheme;
  info.colourpara:=colourpara;
  blockwrite (aFile,info,sizeof(Info),res);
  if res <> sizeof(Infoblk) then begin memo1.lines.add ('Fehler beim Schreiben'); CloseFile (aFile); exit end;
  for y:=0 to ymax-1 do

   begin
   blockwrite (afile,ascreen[y*xmax],xmax*4,res);
   if res <> xmax*4 then begin memo1.lines.add ('Fehler beim Schreiben'); CloseFile(aFile);exit end;
   end;

  CloseFile(aFile);
  end;
 end;
end;

procedure TForm1.ffnen1Click(Sender: TObject);
var info:infoblk;
var afile:File;
var res:integer;
var y:integer;
begin
if opendialog1.execute then
 begin
 if uppercase(Extractfileext (opendialog1.FileName))='.BMP' then
  begin
  Form2.Visible:=true;
  Form2.bringtoFront;
  Form2.image1.Picture.Bitmap.LoadfromFile(opendialog1.filename)
  end
 else
  begin
  assignFile (aFile,opendialog1.FileName);
  reset (aFile,1);
  blockread (aFile,info,3*sizeof(integer),res);
  if res <> 3*sizeof (integer) then  begin memo1.lines.add ('Fehler beim Lesen'); CloseFile(afile); exit end;
  memo1.lines.add (inttostr(info.xmax));
  memo1.lines.add (inttostr(info.ymax));
  memo1.lines.add (inttostr(info.parasize));
  if (sizeof (rtype)<>info.parasize) then begin memo1.lines.add ('Datentyp passt nicht'); CloseFile(afile); exit end;
  reset (aFile,1);
  blockread (aFile,info,sizeof(info),res);
  if (res <>sizeof (info)) then begin memo1.lines.add ('Fehler beim Lesen'); CloseFile(afile); exit end;
  xmax:=info.xmax;
  ymax:=info.ymax;
  R0s:=info.R0s;
  I0s:=info.I0s;
  maxiter:=info.maxiter;
  g:=info.g;
  rwidth:=info.rwidth;
  colourscheme:=info.colourscheme;
  colourpara:=info.Colourpara;

  del:=rwidth/xmax;
  Setparas;
  for y:=0 to ymax-1 do
   begin
      blockread (afile,ascreen[y*xmax],xmax*4,res);
      if res <> xmax*4 then begin memo1.lines.add ('Fehler beim Lesen in Zeile:'+inttostr(y)); CloseFile(aFile);exit end;
   end;

  CloseFile(aFile);
  Form2.showscreen;
  end;
  end;

end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 SetRGBtab(2);
 Form2.showscreen;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
 SetRGBtab(3);
 Form2.showscreen;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
 SetRGBtab(4);
 Form2.showscreen;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
 SetRGBtab (5);
 Form2.showscreen;
end;

procedure TForm1.Button6Click(Sender: TObject);

begin
 SetRGBtab(6);
 Form2.showscreen;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
 SetRGBtab(7);
 Form2.showscreen;
end;

procedure TForm1.Change(Sender: TObject);
begin
changed:=true;
end;


procedure TForm1.cOpenMPClick(Sender: TObject);
begin
eThreads.Enabled:=not cOPenMP.checked;
end;

end.

