Imports System.IO
Imports ICSharpCode.SharpZipLib.Zip
Imports System.Windows.Forms

<ComClass(DateisystemFunktionen.ClassId, DateisystemFunktionen.InterfaceId, DateisystemFunktionen.EventsId)> _
Public Class DateisystemFunktionen

#Region "COM-GUIDs"
    ' Diese GUIDs stellen die COM-Identität für diese Klasse 
    ' und ihre COM-Schnittstellen bereit. Wenn Sie sie ändern, können vorhandene 
    ' Clients nicht mehr auf die Klasse zugreifen.
    Public Const ClassId As String = "b419adec-eb02-45d2-9539-0559a0dc8cec"
    Public Const InterfaceId As String = "b76afde9-f667-4e15-b1c4-bd9b700bf481"
    Public Const EventsId As String = "72c1b73b-746c-4a5e-a3e0-bb4798e73ac2"
#End Region

    'Standard-Konstruktor für COM-Klasse
    Public Sub New()
        MyBase.New()
    End Sub

    '**************************************************************
    'Pfadnamen-Bestandteile isolieren
    '**************************************************************

    Public Function PfadIsolieren(ByVal Pfadname As String) As String
        'Pfad zurückgeben
        Return IO.Path.GetDirectoryName(Pfadname)
    End Function

    Public Function DateinamenIsolieren(ByVal Pfadname As String) As String
        'Dateinamen zurückgeben
        Return IO.Path.GetFileName(Pfadname)
    End Function

    Public Function DateinamenOhneExtensionIsolieren(ByVal Pfadname As String) As String
        'Dateinamen ohne Extension zurückgeben
        Return IO.Path.GetFileNameWithoutExtension(Pfadname)
    End Function

    Public Function ExtensionIsolieren(ByVal Pfadname As String) As String
        'Extension zurückgeben
        Return IO.Path.GetExtension(Pfadname)
    End Function

    '**************************************************************
    'Ein-/Ausgabe
    '**************************************************************

    Public Sub WAVDateiWiedergeben(ByVal Pfadname As String, Optional ByVal Warten As Boolean = False)
        'Wenn Argument Warten True ist, dann...
        If Warten = True Then
            '... WAV-Datei abspielen und auf Wiedergabeende warten
            My.Computer.Audio.Play(Pfadname, AudioPlayMode.WaitToComplete)
            'Ansonsten...
        Else
            '... WAV-Datei im Hintergrund abspielen
            My.Computer.Audio.Play(Pfadname, AudioPlayMode.Background)
        End If
    End Sub

    Public Function Öffnen(ByVal Pfadname As String) As Boolean
        Dim blnErfolg As Boolean = True

        'Folgendes versuchen:
        Try
            'Neuen Prozess starten
            Process.Start(Pfadname)

            'Im Fall eines Fehlers...
        Catch ex As Exception
            '... Misserfolg vermerken
            blnErfolg = False
        End Try

        'Erfolg oder Misserfolg zurückmelden
        Return blnErfolg
    End Function

    Public Function ProgrammStarten(ByVal ProgrammPfadname As String, Optional ByVal DateiPfadname As String = "", Optional ByVal Warten As Boolean = False) As Boolean
        Dim psiProgramm As New ProcessStartInfo
        Dim prcProzess As New Process
        Dim blnErfolg As Boolean = True

        With psiProgramm
            'Programm starten
            .UseShellExecute = False
            'Fenster anzeigen
            .CreateNoWindow = False
            'Name des auszuführenden Programms
            .FileName = ProgrammPfadname
            'Normales Fenster
            .WindowStyle = ProcessWindowStyle.Normal
            'Arbeitsverzeichnis des Programms
            .WorkingDirectory = CurDir()
            'Wenn Datei angegeben, dann...
            If DateiPfadname <> Nothing Then
                '... als Argument übergeben
                .Arguments = DateiPfadname
            End If
        End With

        'Folgendes versuchen:
        Try
            'Neuen Prozess starten
            prcProzess = Process.Start(psiProgramm)
            'Wenn Argument 'Warten' True ist, dann... 
            If Warten = True Then
                '... auf Ende des Prozesses warten
                prcProzess.WaitForExit()
            End If

            'Im Fall eines Fehlers...
        Catch ex As Exception
            '... Misserfolg vermerken
            blnErfolg = False
        End Try

        'Erfolg oder Misserfolg zurückmelden
        Return blnErfolg
    End Function

    Public Function DateiKomprimieren(ByVal Quelldatei As String, ByVal ZipDatei As String, Optional ByVal WarnenWennVorhanden As Boolean = True) As Boolean
        Dim zipZipEintrag As ZipEntry
        Dim blnAbbruch As Boolean = False
        Dim blnErfolg As Boolean = False

        'Wenn Zip-Datei existiert und Warnung aktiv, dann...
        If IO.File.Exists(ZipDatei) AndAlso WarnenWennVorhanden = True Then
            '... nachfragen, ob Zip-Datei überschrieben werden soll. Wenn nicht, dann...
            If MessageBox.Show("Die Datei " & ZipDatei & " existiert bereits." & vbCr & "Möchten Sie sie überschreiben?", APPNAME, MessageBoxButtons.YesNoCancel, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button2) <> DialogResult.Yes Then
                '... Abbruch vermerken
                blnAbbruch = True
            End If
        End If

        'Wenn kein Abbruch stattfinden soll, dann...
        If blnAbbruch = False Then
            '... folgendes versuchen:
            Try
                'ZIP-Ausgabestream in neu angelegte ZIP-Datei öffnen
                Dim zipZipStream As New ZipOutputStream(IO.File.Create(ZipDatei))
                'Mittleren Kompressionslevel einstellen
                zipZipStream.SetLevel(5)

                '... FileStream zum Lesen der Datei anlegen
                Dim fstFileStream As IO.FileStream = IO.File.OpenRead(Quelldatei)
                'Puffer für Aufnahme aller Datei-Bytes anlegen
                Dim bytPuffer(fstFileStream.Length) As Byte

                'Dateiinhalt in Puffer einlesen
                fstFileStream.Read(bytPuffer, 0, bytPuffer.Length)

                '... FileInfo-Objekt für Abruf des Dateinamens anlegen
                Dim finDatei As New IO.FileInfo(Quelldatei)
                'Neuen ZIP-Eintrag mit Dateinamen der Datei anlegen
                zipZipEintrag = New ZipEntry(finDatei.Name)

                With zipZipStream
                    'ZIP-Eintrag in ZIP-Ausgabestream übernehmen
                    .PutNextEntry(zipZipEintrag)
                    'Dateiinhalt in ZIP-Ausgabestream schreiben (und dabei komprimieren)
                    .Write(bytPuffer, 0, bytPuffer.Length)
                    'ZIP-Ausgabe beenden und...
                    .Finish()
                    '... ZIP-Datei schließen
                    .Close()
                End With

                'Aktion erfolgreich
                blnErfolg = True

                'Im Fehlerfall...
            Catch ex As Exception
                '... Fehler melden
                MessageBox.Show(Err.Description, APPNAME, MessageBoxButtons.OK, MessageBoxIcon.Error)
                'Aktion NICHT erfolgreich
                blnErfolg = False
            End Try
        End If

        'Erfolg oder Misserfolg zurückmelden
        Return blnErfolg
    End Function

End Class

