Imports System.Windows.Forms

<ComClass(OrdnerDialog.ClassId, OrdnerDialog.InterfaceId, OrdnerDialog.EventsId)> _
Public Class OrdnerDialog

#Region "COM GUIDs"
    ' These  GUIDs provide the COM identity for this class 
    ' and its COM interfaces. If you change them, existing 
    ' clients will no longer be able to access the class.
    Public Const ClassId As String = "bad103e7-2f30-4046-bac4-ac98fdbf2d44"
    Public Const InterfaceId As String = "9468f182-6255-4a2a-ba2d-04e4e0e72ca2"
    Public Const EventsId As String = "52806700-d4a6-4823-bb03-dba729cab64f"
#End Region

    Private _dlgFolderBrowser As FolderBrowserDialog

    'Erweiterter Konstruktor
    Public Sub New()
        MyBase.New()

        'FolderBrowser-Dialog instanzieren
        _dlgFolderBrowser = New FolderBrowserDialog
        With _dlgFolderBrowser
            'Button "Neuer Ordner" anzeigen
            .ShowNewFolderButton = True
            'Desktop als Root-Ordner verwenden
            .RootFolder = Environment.SpecialFolder.Desktop
        End With
    End Sub

    'Dialog auf Standardwerte zurcksetzen
    Public Sub Zurcksetzen()
        _dlgFolderBrowser.Reset()
    End Sub

    'Angezeigten Meldetext festlegen oder zurckgeben
    Public Property Meldetext() As String
        Get
            Return _dlgFolderBrowser.Description
        End Get
        Set(ByVal value As String)
            _dlgFolderBrowser.Description = value
        End Set
    End Property

    '(Vor-) Gewhlten Ordner festlegen oder zurckgeben
    Public Property GewhlterOrdner() As String
        Get
            Return _dlgFolderBrowser.SelectedPath
        End Get
        Set(ByVal value As String)
            _dlgFolderBrowser.SelectedPath = value
        End Set
    End Property

    'Dialog anzeigen und DialogResult zurckgeben
    Public Function DialogAnzeigen() As Integer
        Return CInt(_dlgFolderBrowser.ShowDialog)
    End Function
End Class


