<ComClass(EnvironmentFunktionen.ClassId, EnvironmentFunktionen.InterfaceId, EnvironmentFunktionen.EventsId)> _
Public Class EnvironmentFunktionen

#Region "COM GUIDs"
    ' These  GUIDs provide the COM identity for this class 
    ' and its COM interfaces. If you change them, existing 
    ' clients will no longer be able to access the class.
    Public Const ClassId As String = "68f67476-34b5-4aa3-a0b9-0d81fd35ca06"
    Public Const InterfaceId As String = "6808e371-5253-4777-8c39-2a46f45b5716"
    Public Const EventsId As String = "250a9952-64b6-4407-b11c-00454f6a2ba0"
#End Region

    'Standard-Konstruktor fr COM-Klasse
    Public Sub New()
        MyBase.New()
    End Sub

    '**************************************************************
    'Windows-Registry
    '**************************************************************

    Public Function RegistryWertLesen(ByVal Schlsselname As String, ByVal Wertname As String, ByVal Vorgabewert As String) As Object
        'Wert des Registry-Schlssels zurckgeben
        Return My.Computer.Registry.GetValue(Schlsselname, Wertname, Vorgabewert)
    End Function

    Public Function RegistryWertSchreiben(ByVal Schlsselname As String, ByVal Wertname As String, ByVal Wert As Object) As Boolean
        'Wert des Registry-Schlssels schreiben
        My.Computer.Registry.SetValue(Schlsselname, Wertname, Wert)

        'Wenn Schlssel jetzt existiert, dann True zurckgeben ansonsten False
        Return My.Computer.Registry.GetValue(Schlsselname, Wertname, "") = Wert
    End Function

    '**************************************************************
    'Systemordner
    '**************************************************************

    Public Function SystemordnerPfadErmitteln(ByVal OrdnerBezeichnung As SystemOrdner) As String
        'Pfad des gewnschten Systemordners zurckgeben
        Return Environment.GetFolderPath(OrdnerBezeichnung)
    End Function

    '**************************************************************
    'Computer-Infos
    '**************************************************************

    Public Function ComputerInfos(ByVal InfoBezeichner As ComputerInfo) As String
        Dim strInfo As String = ""

        'Je nach bergebenem Bezeichner verzweigen
        Select Case InfoBezeichner
            Case ComputerInfo.ComputerBenutzer
                'Namen des eingeloggten Computer-Anwenders ermitteln
                strInfo = RegistryWertLesen("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer", "Logon User Name", "")
            Case ComputerInfo.ComputerName
                'Namen des Computers ermitteln
                strInfo = My.Computer.Name
            Case ComputerInfo.OSName
                'Namen des Betriebssystems ermitteln
                strInfo = My.Computer.Info.OSFullName
            Case ComputerInfo.OSPlattform
                'Plattformtyp des Betriebssystems ermitteln
                strInfo = My.Computer.Info.OSPlatform
            Case ComputerInfo.OSVersion
                'Version des Betriebssystems ermitteln
                strInfo = My.Computer.Info.OSVersion
            Case ComputerInfo.RamVerfgbar
                'Gre des verfgbaren phsysikalischen Speichers in Bytes ermitteln
                strInfo = My.Computer.Info.AvailablePhysicalMemory
            Case ComputerInfo.RamVorhanden
                'Gre des vorhandenen phsysikalischen Speichers in Bytes ermitteln
                strInfo = My.Computer.Info.TotalPhysicalMemory
            Case ComputerInfo.VirtRamVerfgbar
                'Gre des verfgbaren virtuellen Speichers in Bytes ermitteln
                strInfo = My.Computer.Info.AvailableVirtualMemory
            Case ComputerInfo.VirtRamVorhanden
                'Gre des vorhandenen virtuellen Speichers in Bytes ermitteln
                strInfo = My.Computer.Info.TotalVirtualMemory
        End Select

        'Jeweilige Info zurckgeben
        Return (strInfo)
    End Function

End Class

