/* $Id: Lexicon.h 1215 2006-10-17 08:10:24Z olau $ */

/* 
   Copyright (C) 2006 Oliver Lau <ola@ctmagazin.de>,
                      Ingmar Thilo
   Copyright (C) 2006 Heise Zeitschriften Verlag.
   Alle Rechte vorbehalten.
*/

#ifndef __LEXICON_H_
#define __LEXICON_H_

#include <iostream>
#include <vector>


class Lexicon
{
public: // methods

  /// Konstruktor.
  Lexicon(void) : idx(0)
  {
    // Speicher fr Lexikon reservieren
    lex = new int[MAX_LEX_SIZE];
    clear();
  }

  /// Destruktor.
  ~Lexicon(void)
  {
    delete [] lex;
  }

  /// Lexikon mit Nullen initialisieren.
  void clear(void)
  {
    for (int i = 0; i < MAX_LEX_SIZE; ++i)
      lex[i] = 0;
  }

  /// tatschlich von Lexikoneintrgen bentigten Speicher
  /// in Bytes zurckgeben.
  inline int size(void)
  {
    return idx * sizeof(int);
  }

  /// Handelt es sich bei dem bergebenen Zeichen um ein
  /// darstellbares?
  inline bool is_char(int x)
  {
    return ((x > 64 && x < 91)
      || (x > 47 && x < 58)
      || (x > 96 && x < 123)
      || (x > 128 && x < 255));
  }

  void add(const char *word);
  void add(std::istream &input);
  bool contains(const char *word, bool find_only_once = true);
  int cross(std::istream &input, std::ostream &output);
  int cross(std::vector<char *> &wordlist);
  int cross(std::vector<char *> &wordlist, std::ostream &output);


private: // variables

  enum flags {
    END_OF_WORD  = 0x0001,
    VISITED      = 0x0002,
  };

  /// Maximal Gre des Lexikon-Speichers.
  static const int MAX_LEX_SIZE = 10*1024*1024; // 10 MByte

  /// Maximal erlaubte Schlssellnge.
  static const int MAX_WORD_LENGTH = 100;

  /// Zeiger auf nchstes freie Zelle in lex.
  int idx;

  /// Zeiger auf Speicherbereich, der fr das Lexikon reserviert wurde.
  int *lex;


private: // methods

  int readword(char *word, std::istream &input);
};


#endif /* __LEXICON_H_ */
