/* $Id: main.cpp 1213 2006-10-17 05:53:09Z olau $ */

/* 
   Copyright (C) 2006 Oliver Lau <ola@ctmagazin.de>,
                      Ingmar Thilo
   Copyright (C) 2006 Heise Zeitschriften Verlag.
   Alle Rechte vorbehalten.
*/

#include <iostream>
#include <fstream>
#include <vector>

using namespace std;

#include "Lexicon.h"

#include "../timer/timer.h"

#include "../testdata/testdata.h"
const char *file_cross = "../../diff-bintrie.txt";

Lexicon lex;

/// Wort in Wrterbuch nachschlagen.
bool lookup(const char *w, bool contained)
{
  bool found = lex.contains(w);
  bool ok = (found == contained);
  cout << w << ": "
    << (found? "GEFUNDEN" : "nicht gefunden")
    << " -> "
    << (ok? "ok" : "FEHLER")
    << endl;
  return ok;
}


int main(int argc, char *argv[])
{
  LONGLONG t;

  std::vector<char *> wordlist;

  fstream f1;
  fstream f2;

  f1.open(file1, ios::in);
  if (f1.fail())
  {
    cerr << "Fehler beim ffnen der Datei '" << file1 << "'.\n";
    exit(1);
  }

  cout << "Indexieren der Datei '" << file1 << "' ...";
  readfile(wordlist, f1);
  START();
  //for (size_t i = 0; i < wordlist.size(); ++i)
  //  lex.add(wordlist[i]);
  lex.add("Trie");
  lex.add("Tripod");
  STOP(t);
  f1.close();
  wordlist.clear();

  cout << endl << "Dauer: " 
    << (1000ULL*t/T_RESULT_RESOLUTION) << " ms" 
    << endl;

  cout << endl << endl <<
    "Gre des Lexikons: " 
    << lex.size() << " Byte"
    << endl;


#if DO_TESTS
  bool ok = true;
  ok = ok && lookup("Pride", true);
  ok = ok && lookup("Prejudice", true);
  ok = ok && lookup("Jane", true);
  ok = ok && lookup("Tarzan", false);
  ok = ok && lookup("single", true);
  ok = ok && lookup("universally", true);
  ok = ok && lookup("goodie", false);
  ok = ok && lookup("a", true);
  ok = ok && lookup("caprice", true);
  ok = ok && lookup("chapter", false);
  ok = ok && lookup("Chapter", true);
  ok = ok && lookup("ductility", true);
  ok = ok && lookup("duct", false);
  ok = ok && lookup("ala", false);
  cout << endl 
    << (ok? "Alle Tests bestanden." : "Einige Tests sind fehlgeschlagen.")
    << endl << endl;
#endif /* DO_TESTS */

  cout << "Schnittmenge zur Datei '" << file2 << "' berechnen ...";

  f2.open(file2, ios::in);
  if (f2.fail())
  {
    cerr << "Fehler beim ffnen der Datei '" << file2 << "'.\n";
    exit(1);
  }

#if WRITE_CROSS
  fstream cross;
  cross.open(file_cross, ios::out);
  if (cross.fail())
  {
    cerr << "Fehler beim ffnen der Datei '" << file_cross << "'.\n";
    exit(1);
  }
#endif

  readfile(wordlist, f2);

  START();
#if WRITE_CROSS
  int num_words = lex.cross(wordlist, cross);
#else
  int num_words = lex.cross(wordlist);
#endif
  STOP(t);

  f2.close();
#if WRITE_CROSS
  cross.close();
#endif

  cout << endl << "Dauer: " 
    << (1000ULL*t/T_RESULT_RESOLUTION) << " ms" 
    << endl;

  cout << endl << endl <<
    "Anzahl der in beiden Dateien vorhandenen Wrter: " 
    << num_words << endl;

  return 0;
}
