import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.net.URL;

/**
 * @author Michael Tamm
 */
public class TrayIconDemo {
    public static void main(String... args) throws Exception {
        if (!SystemTray.isSupported()) {
            System.err.println("Der System-Tray wird auf diesem System leider nicht untersttzt.");
        } else {
            // Konstruiere Kontextmen ...
            PopupMenu contextMenu = new PopupMenu();
            MenuItem menuItem = new MenuItem("Beenden");
            menuItem.addActionListener(
                new ActionListener() {
                    public void actionPerformed(ActionEvent e) {
                        System.exit(0);
                    }
                }
            );
            contextMenu.add(menuItem);
            // Konstruiere Tray-Icon ...
            URL iconUrl = TrayIconDemo.class.getResource("/ct_logo.png");
            Image iconImage = Toolkit.getDefaultToolkit().getImage(iconUrl);
            TrayIcon trayIcon = new TrayIcon(iconImage, "TrayIconDemo", contextMenu);
            // Zum System-Tray hinzufgen ...
            SystemTray tray = SystemTray.getSystemTray();
            tray.add(trayIcon);
        }
    }
}
