#if !defined(__VistaSDK_h)
#define __VistaSDK_h

/*	Projekt UacTest
	SpeedProject
	Copyright  1995 - 2006. Alle Rechte vorbehalten.

	Datei:		VistaSDK.h
	Autor:		Sven Ritter
	Datum:		15.11.2006 - 15:39:04


	UEBERBLICK
	==========
	SDK-Definitionen fuer Vista
*/


// ****************************************************************************
// ******                Header nur einmal pro Build includen            ******
// ****************************************************************************
#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


// ****************************************************************************
// ******                Definition zu _TOKEN_ELEVATION_TYPE             ******
// ****************************************************************************
typedef enum _TOKEN_ELEVATION_TYPE
{
    TokenElevationTypeDefault = 1,
    TokenElevationTypeFull,
    TokenElevationTypeLimited,

} TOKEN_ELEVATION_TYPE, *PTOKEN_ELEVATION_TYPE;


// ****************************************************************************
// ******             Definition zu tagTOKEN_INFORMATION_CLASS2          ******
// ****************************************************************************
typedef enum tagTOKEN_INFORMATION_CLASS2
{
    TokenElevationType = TokenOrigin + 1,
    TokenLinkedToken,
    TokenElevation,
    TokenHasRestrictions,
    TokenAccessInformation,
    TokenVirtualizationAllowed,
    TokenVirtualizationEnabled,
    TokenIntegrityLevel,
    TokenUIAccess,
    TokenMandatoryPolicy,
    TokenLogonSid,

} TOKEN_INFORMATION_CLASS2;


// ****************************************************************************
// ******                    Definition zu tagBIND_OPTS3                 ******
// ****************************************************************************
typedef struct tagBIND_OPTS3 : tagBIND_OPTS2
{
    HWND hwnd;

} BIND_OPTS3, *LPBIND_OPTS3;


// Macro to use on a button or command link to display an elevated icon
#define BCM_SETSHIELD            (BCM_FIRST + 0x000C)
#define Button_SetElevationRequiredState(hwnd, fRequired) \
    (LRESULT)SNDMSG((hwnd), BCM_SETSHIELD, 0, (LPARAM)fRequired)


// ****************************************************************************
// ******                        INLINE-Definitionen                     ******
// ****************************************************************************


#endif										// __VistaSDK_h


// ****************************************************************************
// ******                            END OF FILE                         ******
// ****************************************************************************