/* $Id: globaldefs.h 1393 2006-12-13 11:56:05Z olau $
 *
 * Copyright (C) 2006 Oliver Lau <ola@heise.de>, Heise Zeitschriften Verlag
 * All rights reserved. 
 *
 */
#ifndef __HELPER_H_
#define __HELPER_H_

#include <malloc.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <stdarg.h>
#include <string.h>


#ifndef NULL
#define NULL                (0)
#endif /* NULL */

#ifndef FALSE
#define FALSE               (0)
#endif /* FALSE */

#ifndef TRUE
#define TRUE                (1)
#endif /* TRUE */


#if __STDC_VERSION__ < 199901 && !defined(__GNUC__) && !defined(inline)
#define inline
#endif

#define errno_abort(txt) \
    do { \
        fprintf(stderr, "%s at \"%s\":%d: %s (%d)\n", \
                txt, __FILE__, __LINE__, \
                strerror(errno), errno); \
        exit(errno); \
    } while(0)

#define err_abort(txt) \
    do { \
        fprintf(stderr, "%s at \"%s\":%d\n", txt, __FILE__, __LINE__); \
        exit(errno); \
    } while(0)

#define warn(txt) \
    do { \
        fprintf(stderr, "\n%s (\"%s\":%d)\n", \
        txt, __FILE__, __LINE__); \
    } while(0)

#define MPI_Error(txt, comm, errno) \
    do { \
        fprintf(stderr, "\n%s (\"%s\":%d)\n", \
        txt, __FILE__, __LINE__); \
        MPI_Abort(comm, errno); \
    } while(0)

#define MPI_Errno(txt, comm) \
    do { \
        fprintf(stderr, "\n%s (\"%s\":%d) %s (%d)\n", \
        txt, __FILE__, __LINE__, \
        strerror(errno), errno); \
        MPI_Abort(comm, errno); \
    } while(0)

#ifdef DEBUG
#define INFO(txt) \
    do { \
        printf("INFO: %s\n", txt); \
        fflush(stdout); \
    } while(0)
#else
#define INFO(txt)
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef int bool;

#if defined(_MSC_VER) || defined(__BORLANDC__)
#pragma warning(disable : 4305)
typedef __int8  int8_t;
typedef __int16 int16_t;
typedef __int32 int32_t;
typedef __int64 int64_t;
typedef unsigned __int8  uint8_t;
typedef unsigned __int16 uint16_t;
typedef unsigned __int32 uint32_t;
typedef unsigned __int64 uint64_t;
typedef float  float32_t;
typedef double float64_t;
#elif defined (__GNUC__)
#define __int8_t_defined
#define uint8_t unsigned char
#define uint16_t unsigned short
#define uint32_t unsigned int
#define uint64_t unsigned long long
#define int8_t signed char
#define int16_t signed short
#define int32_t signed int
#define int64_t signed long long
typedef unsigned char BYTE;
#endif

#ifdef __cplusplus
}
#endif

#endif /* __HELPER_H_ */
