/*
============================================================================
 Name        : HelloworldApp.cpp
 Author      : Frank Fitzek And Morten V. Pedseren
 Copyright   : Mobile Devices Team - AAU
 Description : Main application class
============================================================================
*/

// INCLUDE FILES
#include    "HelloworldApp.h"
#include    "HelloworldDocument.h"

// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// CHelloworldApp::AppDllUid()
// Returns application UID
// ---------------------------------------------------------
//
TUid CHelloworldApp::AppDllUid() const
    {
    return KUidHelloworld;
    }


// ---------------------------------------------------------
// CHelloworldApp::CreateDocumentL()
// Creates CHelloworldDocument object
// ---------------------------------------------------------
//
CApaDocument* CHelloworldApp::CreateDocumentL()
    {
    return CHelloworldDocument::NewL( *this );
    }

// ================= OTHER EXPORTED FUNCTIONS ==============
//
// ---------------------------------------------------------
// NewApplication()
// Constructs CHelloworldApp
// Returns: created application object
// ---------------------------------------------------------
//
EXPORT_C CApaApplication* NewApplication()
    {
    return new CHelloworldApp;
    }

// ---------------------------------------------------------
// E32Dll(TDllReason)
// Entry point function for EPOC Apps
// Returns: KErrNone: No error
// ---------------------------------------------------------
//
GLDEF_C TInt E32Dll( TDllReason )
    {
    return KErrNone;
    }



