property exceptions : "Admin|Serv|Svr|Srvr|Xserv|Xsan"


property actionButton : missing value
property intelButton : missing value
property ppcButton : missing value
property optionsMatrix : missing value

property prefsPanel : missing value
property wgetPath : missing value


on clicked theObject
	if name of theObject is "intel" or name of theObject is "ppc" then
		set enabled of actionButton to ((state of ppcButton) + (state of intelButton))
		--
	else if name of theObject is "prefs" then
		doPrefsPanel()
		--
	else if name of theObject is "action" then
		set enabled of actionButton to false
		set title of actionButton to "Stop"
		tell progress indicator "spinner" of window "main" to start
		
		--URLs fr Server- und nicht bentigte CPU-Version weglassen
		if state of ppcButton is 0 then set exceptions to exceptions & "|PPC"
		if state of intelButton is 0 then set exceptions to exceptions & "|Intel"
		
		getUpdates(current row of optionsMatrix, exceptions)
		
		tell progress indicator "spinner" of window "main" to stop
		set title of actionButton to "Start"
		set enabled of actionButton to true
		setStatus("")
		--
	end if
end clicked


on getUpdates(option, exceptions)
	setStatus("configParams")
	set sharedNetworkSettings to call method "sharedNetworkSettings" of class "NSNetworkSettings"
	if not (call method "connectedToInternet:" of sharedNetworkSettings with with parameter) as boolean then
		handleError("noInternetConnection")
		return
	end if
	
	--Proxy?
	set tmp to getProxyForServer("http://swscan.apple.com")
	if tmp contains "http" then
		set wgetCmd to wgetPath & "-e http_proxy=" & tmp & " --proxy=on "
	else
		set wgetCmd to wgetPath
	end if
	
	set sucatalog to "/private/tmp/sumirror.sucatalog." & (random number 1000000) as string
	
	setStatus("getSUCatalog")
	
	--Update-Liste vom Apple-Server laden
	try
		do shell script "/bin/mkdir -p ~/Library/Logs"
		set catalog to do shell script wgetCmd & "-N -O " & sucatalog & " http://swscan.apple.com/content/catalogs/index-1.sucatalog"
	on error what
		handleError("wgetError")
		return
	end try
	
	--alle URLs extrahieren und in allURLsFile abspeichern
	setStatus("extractURLs")
	set urls to do shell script "/usr/bin/awk -F'>' '/string/ {print $2}' " & sucatalog & " | awk -F'<' '{print $1}'"
	set tmp to saveData2File("allURLs", urls as text)
	set allURLsFile to tmp & ".1"
	
	--Mac- in Unix-Zeilenenden umwandeln, sonst grep'ts nicht
	do shell script "/usr/bin/tr '\\r' '\\n' < " & tmp & " > " & allURLsFile
	
	--unntige URLs eliminieren
	setStatus("processURLs")
	set cpuURLs to do shell script "/usr/bin/grep -v -i -E '" & exceptions & "' " & allURLsFile
	
	--urlListFile enthlt alle Pfade fr wget
	set tmp to saveData2File("cpuURLs", cpuURLs as text)
	set urlListFile to tmp & ".1"
	
	--Mac- in Unix-Zeilenenden umwandeln, sonst mag wget nicht
	do shell script "/usr/bin/tr '\\r' '\\n' < " & tmp & " > " & urlListFile
	
	--Speicherorte ermitteln
	if option is 1 then
		--Disk-Image anlegen unter imagePath
		--Pakete liegen am Ende unter ~/Documents/Offline-Update
		set basePath to (path to documents folder as string)
		--
	else if option is 2 then
		--externes Laufwerk volumeName
		--Pakete liegen am Ende unter /Volumes/volumeName/Offline-Update
		set tmp to (contents of default entry "volumeName" of user defaults)
		if tmp is not in (list disks) then
			handleError(localizedString("missingExternal_1") & tmp & localizedString("missingExternal_2"))
			return
		else
			set basePath to tmp & ":"
		end if
		--
	else if option is 3 then
		--Server-Pfad
		set basePath to (path to sites folder as string)
		--
	else
		handleError("quirkyOptions")
		return
	end if
	
	-- Verzeichnisse, falls ntig, anlegen
	tell application "Finder"
		try
			get info for alias (basePath & "Offline-Update:") without size
		on error
			make new folder at alias basePath with properties {name:"Offline-Update"}
		end try
		
		try
			get info for alias (basePath & "Offline-Update:Pakete:") without size
		on error
			make new folder at alias (basePath & "Offline-Update:") with properties {name:"Pakete"}
		end try
	end tell
	
	set basePath to basePath & "Offline-Update:"
	set basePathU to escapeSpaces(POSIX path of basePath)
	
	--Update-Pakete herunterladen
	setStatus("loadPackages")
	do shell script wgetCmd & "-N -i " & urlListFile & " -P " & basePathU & "Pakete"
	
	setStatus("optimizingPackages")
	--Hier wre eine gute Gelegenheit, um alte Pakete zu lschen.
	--aus urlListFile alle Dateinamen (awk-Schlange) extrahieren und mit dem Inhalt von basePathU & "Pakete" vergleichen
	
	--set AppleScript's text item delimiters to ASCII character 13
	--set tmp to every text item of urls
	
	--set pool to (list folder (basePath & "Pakete:"))
	
	--set AppleScript's text item delimiters to "/"
	
	--repeat with oneURL in tmp
	--	set aURL to last text item of oneURL
	--	if aURL is not in pool then display dialog ("FYI: I would delete file '" & aURL & "'") buttons {"OK"} default button 1
	--end repeat
	
	--set AppleScript's text item delimiters to ""
	
	setStatus("createSUCatalog")
	
	if option is 1 then
		do shell script "/usr/bin/sed -e 's|<string>http://swcdn.*/\\(.*\\)</string>|<string>file:///Volumes/Offline-Update/Pakete/\\1</string>|g' " & sucatalog & " > " & (basePathU & "update.sucatalog")
		
		try
			setStatus("createImage")
			do shell script "/usr/bin/hdiutil create -ov -srcfolder " & basePathU & " -volname Offline-Update " & (escapeSpaces(contents of default entry "imagePath" of user defaults) & "Offline-Update.dmg")
		on error
			handleError("hdiutilError")
			return
		end try
		--
	else if option is 2 then
		do shell script "/usr/bin/sed -e 's|<string>http://swcdn.*/\\(.*\\)</string>|<string>file:///Volumes/" & escapeSpaces(contents of default entry "volumeName" of user defaults) & "/Offline-Update/Pakete/\\1</string>|g' " & sucatalog & " > " & (basePathU & "update.sucatalog")
		--
	else if option is 3 then
		do shell script "/usr/bin/sed -e 's|<string>http://swcdn.*/\\(.*\\)</string>|<string>http://" & (contents of default entry "websitesPath" of user defaults) & "/Offline-Update/Pakete/\\1</string>|g' " & sucatalog & " > " & (basePathU & "update.sucatalog")
		--
	end if
end getUpdates


on setStatus(msg)
	set contents of text field "status" of window "main" to localizedString(msg)
	call method "displayIfNeeded" of window "main"
end setStatus


on awake from nib theObject
	set actionButton to (button "action" of window "main")
	set intelButton to (button "intel" of window "main")
	set ppcButton to (button "ppc" of window "main")
	set optionsMatrix to (matrix "options" of window "main")
	
	readOliUPrefs()
	
	set tmp to (contents of default entry "architecture" of user defaults)
	if "Intel" is in tmp then set state of intelButton to 1
	if "PPC" is in tmp then set state of ppcButton to 1
	
	set current row of optionsMatrix to (contents of default entry "action" of user defaults)
	
	set wgetPath to escapeSpaces((resource path of main bundle)) & "/wget -o " & POSIX path of (path to home folder as string) & "Library/Logs/wget_swupdate.log "
end awake from nib


on will quit theObject
	saveOliUPrefs()
end will quit


on readOliUPrefs()
	-- Default-Einstellungen schreiben
	-- existieren bereits welche, werden diese NICHT berschrieben
	tell user defaults
		make new default entry at end of default entries with properties {name:"architecture", content:{"Intel", "PPC"}}
		make new default entry at end of default entries with properties {name:"action", content:1}
		make new default entry at end of default entries with properties {name:"imagePath", content:(POSIX path of (path to desktop folder))}
		make new default entry at end of default entries with properties {name:"volumeName", content:"iPod"}
		make new default entry at end of default entries with properties {name:"websitesPath", content:"192.168.1.100"}
	end tell
	call method "synchronize" of object user defaults
end readOliUPrefs


on saveOliUPrefs()
	if state of intelButton is 1 then set tmp to {"Intel"}
	if state of ppcButton is 1 then set tmp to tmp & "PPC"
	set contents of default entry "architecture" of user defaults to tmp
	
	set contents of default entry "action" of user defaults to (current row of optionsMatrix)
	
	call method "synchronize" of object user defaults
end saveOliUPrefs


on panel ended thePanel with result theResult
	if theResult is 1 then
		tell thePanel
			set contents of default entry "imagePath" of user defaults of application "OliU" to (alternate title of button "imagePathBtn")
			set contents of default entry "volumeName" of user defaults of application "OliU" to (contents of text field "volumeName")
			set contents of default entry "websitesPath" of user defaults of application "OliU" to (contents of text field "websitesPath")
		end tell
		call method "synchronize" of object user defaults
	end if
end panel ended


on choose menu item theObject
	if name of theObject is "prefsItem" then
		doPrefsPanel()
	else if name of theObject is "closeItem" then
		quit application "OliU"
	end if
end choose menu item


on doPrefsPanel()
	if prefsPanel is equal to missing value then
		load nib "PrefsPanel"
		set prefsPanel to window "prefs"
	end if
	
	tell prefsPanel
		set tmp to (contents of default entry "imagePath" of user defaults of application "OliU")
		set alternate title of button "imagePathBtn" to tmp
		set tmp to (call method "lastPathComponent" of tmp)
		set contents of text field "imagePath" to tmp
		
		set contents of text field "volumeName" to (contents of default entry "volumeName" of user defaults of application "OliU")
		set contents of text field "websitesPath" to (contents of default entry "websitesPath" of user defaults of application "OliU")
	end tell
	
	display panel prefsPanel attached to window "main"
end doPrefsPanel


on escapeSpaces(path)
	return do shell script "echo '" & path & "' | /usr/bin/sed -e 's|[ ]|\\\\ |g'"
end escapeSpaces


on saveData2File(fileName, theData)
	set thePath to (path to startup disk as string) & "private:tmp:" & fileName & "." & (random number 1000000) as string
	
	try
		set theFile to open for access thePath with write permission
	on error what
		set thePath to (path to startup disk as string) & "private:tmp:" & fileName & "." & (random number 1000000) as string
		set theFile to open for access thePath with write permission
	end try
	
	write theData to theFile
	close theFile
	
	return (POSIX path of thePath)
end saveData2File


on getProxyForServer(serverURL)
	set theURLWithString to call method "URLWithString:" of class "NSURL" with parameter serverURL
	set sharedNetworkSettings to call method "sharedNetworkSettings" of class "NSNetworkSettings"
	set proxyPropertiesForURL to call method "proxyPropertiesForURL:" of sharedNetworkSettings with parameter theURLWithString
	
	try
		tell |kCFStreamPropertyHTTPProxy| of proxyPropertiesForURL
			if ((its |HTTPEnable|) = 1) then
				return "http://" & its |HTTPProxy| & ":" & (its (|HTTPPort|) as integer)
			else
				return ""
			end if
		end tell
	on error what
		return ""
	end try
end getProxyForServer


on handleError(msg)
	display dialog localizedString(msg) buttons {"OK"} default button 1
end handleError


on localizedString(key)
	return (localized string of key from table "InfoPlist")
end localizedString