// $Id: MandelbrotSet.cpp 302 2007-05-03 15:20:29Z olau $

#include "stdafx.h"


MandelbrotSet::MandelbrotSet()
: threshold(4.0), maxIterations(MandelbrotDefaultDepth), algorithm(C), scheme(NULL)
{
}


__int64
MandelbrotSet::renderLine_SSE2(double re0, double im0, COLORREF *scanLine, double scaleFactor)
{
    
    __int64 cumulatedIters = 0;
    __declspec(align(16)) double scale = scaleFactor;
    __declspec(align(16)) double im = im0;
    __declspec(align(16)) double re = re0;
#pragma pack(1)
    __declspec(align(16)) double thres[] = {threshold, threshold};
#pragma pack()
    for (int w = 0; w < width; w += 2)
    {
        __asm {
            
        };
    }
    return cumulatedIters;
}


__int64
MandelbrotSet::renderLine_C(double re0, double im0, COLORREF *scanLine, double scaleFactor)
{
    __int64 cumulatedIters = 0;
    __declspec(align(16)) double scale = scaleFactor;
    __declspec(align(16)) double im = im0;
    __declspec(align(16)) double re = re0;
    __declspec(align(16)) double thres = threshold;
    for (int w = 0; w < width; ++w)
    {
        __declspec(align(16)) double sum = 0;
        __declspec(align(16)) double x = 0;
        __declspec(align(16)) double y = 0;
        int i;
        __asm align 16;
        for (i = 0; i < maxIterations; ++i)
        {
            double xt = x * x - y * y + re;
            double yt = x * y + x * y + im;
            x = xt;
            y = yt;
            sum = x * x + y * y;
            if (sum > thres)
                break;
        }
        cumulatedIters += i;
        *scanLine++ = (i == maxIterations)? 0 : scheme->color(i); 
        re += scale;
    }
    return cumulatedIters;
}


__int64
MandelbrotSet::render(double reC, double imC, double scale, const BITMAP *bitmap, bool *restart)
{
    if (scheme == NULL)
        scheme = new ColorScheme;
    __int64 iters = 0;
    for (;;)
    {
        iters = 0;
        int y;
        width = bitmap->bmWidth;
        const int halfWidth = width / 2;
        height = bitmap->bmHeight;
        const int halfHeight = height / 2;
        const double re0 = reC - scale * halfWidth;
        for (y = 0; y < height; ++y)
        {
            if (*restart)
                break;
            COLORREF *scanLine = (COLORREF *) bitmap->bmBits + y * width;
            const double im0 = imC + scale * (y - halfHeight);
            iters += renderLine_C(re0, im0, scanLine, scale);
        }
        *restart = false;
        if (y == height)
            break;
    }
    return iters;
}
