// $Id: Mutex.h 275 2007-04-30 08:25:32Z olau $

#pragma once

#include "stdafx.h"

class Mutex
{
public:
    Mutex()
    {
        InitializeCriticalSection(&m_critSect);
    }

    void lock()
    {
        EnterCriticalSection(&m_critSect);
    }

    void unlock()
    {
        LeaveCriticalSection(&m_critSect);
    }

private:
    CRITICAL_SECTION m_critSect;
};


class MutexLocker
{
public:
    MutexLocker(Mutex& mutex): m_mutex(mutex)
    {
        m_mutex.lock();
    }

    ~MutexLocker()
    {
        m_mutex.unlock();
    }

private:
    Mutex& m_mutex;
};
