// $Id: ThreadPool.h 277 2007-04-30 10:31:18Z olau $

#pragma once

#include "stdafx.h"

class ThreadPool;
class Job;
class Mutex;

///////////////////////////////////////////////////////////////////
// class WorkerThread
///////////////////////////////////////////////////////////////////

class WorkerThread : public Thread
{
public:
    WorkerThread(ThreadPool *pool, HANDLE hTriggerEvent, HANDLE hReadyEvent, LPCSTR name = NULL)
        : pool(pool), hTriggerEvent(hTriggerEvent), hReadyEvent(hReadyEvent), name(name), doQuit(false)
    { }
    THREADRESULT run();

protected:
    bool doQuit;
    friend class ThreadPool;

private:
    HANDLE hTriggerEvent;
    HANDLE hReadyEvent;
    ThreadPool *pool;
    LPCSTR name;

    void waitForTrigger();
    int signalReady();
};


///////////////////////////////////////////////////////////////////
// class ThreadPool
///////////////////////////////////////////////////////////////////

class ThreadPool
{
public:
    ThreadPool(int);
    ~ThreadPool();

    void setMaximumNumberOfThreads(int);
    void enqueue(Job *);
    void waitForAll();

    int run();
    void stop();

    Job *nextJob();

    static const int ThreadHardLimit = 128;

    enum ErrorCode 
    {
        NoError = 0,
        ThreadHardLimitReached,
        CreateEventFailed,
        SetEventFailed,
        InvalidHandle,
    };

private:
    WorkerThread *pool[ThreadHardLimit];
    HANDLE hReadyEvent[ThreadHardLimit];
    HANDLE hTriggerEvent[ThreadHardLimit];
    int numberOfThreads;
    int maximumNumberOfThreads;
    Mutex *m_mutex;
    std::queue <Job *, std::deque<Job *> > jobs;

    int signalAll();
    void quitAll();
};
