#!/bin/bash
#                                            von Mirko Dlle <mid@ct.heise.de>
#
# autowlan -- Sucht nach dem ersten WLAN-Adapter im System, scannt
#             nach offenen WLAN-Netzen und meldet sich nacheinander
#             bei allen an, um OpenVPN das Nachhausetelefonieren
#             zu ermglichen. Bei bestehender WLAN-Verbindung zu einem
#             Access Point wird nichts unternommen.

# Ersten WLAN-Adapter finden
for WLAN in /sys/class/net/*; do
  if [ -d "${WLAN}/wireless" ]; then
    WLAN=${WLAN##*/}
    break
  fi
done

# Nur in Aktion treten, wenn keine Verbindung zu einem AP besteht
WSTATUS=$(iwconfig ${WLAN})
if [ -n "${WSTATUS/*unassociated*}" ]; then
  echo "WLAN-Verbindung besteht bereits."
  exit 0
fi

# Nach WLAN-Netzen (Zellen) scannen
WCELLS=$(iwlist ${WLAN} scan)

# Die Zelleninformationen in Blcke aufteilen
IFS=""
WCELLS="${WCELLS//Cell/$'\t'}"
IFS=$'\t'
set -- ${WCELLS}

# Die Zellen einzeln prfen
IFS=""
while [ "${#@}" -gt "0" ]; do
  # Nur offene WLANs verwenden
  if [ -z "${1/*Encryption key:off*}" ]; then
    # ESSID gewinnen
    ESSID="${1#*ESSID:\"}"
    ESSID="${ESSID%%\"*}"
    # WLAN-Adapter einrichten
    iwconfig ${WLAN} essid "${ESSID}"
    sleep 1

    # Verbindungs-Status berprfen
    WSTATUS=$(iwconfig ${WLAN})
    if [ -n "${WSTATUS/*unassociated*}" ]; then
      # Access Point hat die Verbindung zugelassen
      # IP-Adresse per DHCP besorgen
      dhclient ${WLAN} >/dev/null 2>/dev/null
      # 1 Minute warten, damit OpenVPN nach Hause telefonieren kann
      echo "1 Minute warten, um nach Hause zu telefonieren (${WLAN}, ${ESSID})"
      sleep 1m
    else
      # Access Point akzeptiert uns nicht
      echo "Verbindung zum AP fehlgeschlagen (${WLAN}, ${ESSID})"
    fi
  fi
  shift
done
