/*
 * dummy_db.h
 * ----------
 *
 * Demo functions which are needed for a standalone test of the programs
 * "dbselect.c" and "dedupl.c".
 *
 * Copyright (c):
 * 2007:  Joerg MICHAEL, Adalbert-Stifter-Str. 11, 30655 Hannover, Germany
 *
 * SCCS: @(#) dummy_db.h  1.1  2007-11-15
 *
 * This file is subject to the GNU Lesser General Public License (LGPL)
 * (formerly known as GNU Library General Public Licence)
 * as published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this file; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Actually, the LGPL is __less__ restrictive than the better known GNU General
 * Public License (GPL). See the GNU Library General Public License or the file
 * LIB_GPLA.TXT for more details and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * There is one important restriction: If you modify this program in any way
 * (e.g. modify the underlying logic or translate this program into another
 * programming language), you must also release the changes under the terms
 * of the LGPL.
 * (However, since __this__ program is intended to be customized, all changes
 * covered by TO-DO comments are free.)
 *
 * That means you have to give out the source code to your changes,
 * and a very good way to do so is mailing them to the address given below.
 * I think this is the best way to promote further development and use
 * of this software.
 *
 * If you have any remarks, feel free to e-mail to:
 *     ct@ct.heise.de
 *
 * The author's email address is:
 *    astro.joerg@googlemail.com
 */


#ifndef _DUMMY_DB_INCLUDED_

#define _DUMMY_DB_INCLUDED_


/****  standalone test  ****/

#undef  MIN_POS_WILDCARD_FAM_NAME
#undef  MIN_POS_WILDCARD_FIRST_NAME
#undef  MIN_POS_WILDCARD_ZIP_CODE
#undef  MIN_POS_WILDCARD_BIRTHDAY

#define  MIN_POS_WILDCARD_FAM_NAME     0
#define  MIN_POS_WILDCARD_FIRST_NAME   0
#define  MIN_POS_WILDCARD_ZIP_CODE     0
#define  MIN_POS_WILDCARD_BIRTHDAY     0


static FILE *fr_test;
static char *file = FILE_FOR_STANDALONE_TEST;

static struct MAIL_ADDR dummy_db_addr[] =
   { { db_gender,      LENGTH_GENDER      },
     { db_first_name,  LENGTH_FIRST_NAME  },
     { db_fam_name,    LENGTH_FAM_NAME    },
     { db_street,      LENGTH_STREET      },
     { db_zip_code,    LENGTH_ZIP_CODE    },
     { db_city,        LENGTH_CITY        },
     { db_country,     LENGTH_COUNTRY     },

     { db_full_birthday,LENGTH_FULL_BIRTHDAY },
     { db_phone_number, LENGTH_PHONE_NUMBER  },
     { db_mobile_number,LENGTH_MOBILE_NUMBER },
     { db_iban_code,    LENGTH_IBAN_CODE    },
     { db_bank_account, LENGTH_BANK_ACCOUNT },
     { db_cust_number,  LENGTH_CUST_NUMBER  },
     {   NULL,              0               }
   };



static void open_database (void)
{
  sql_err_code = SQL_SUCCESS;
  if ((fr_test = fopen (file,"r")) == NULL)
    {
     sql_err_code = -111L;
     printf ("Error: could not open standalone file '%s'\n", file);
    }
}


static void close_database (void)
{
  fclose (fr_test);
  sql_err_code = SQL_SUCCESS;
}


static void declare_cursor (void)
{
  sql_err_code = SQL_SUCCESS;
  if (fseek (fr_test, 0L, SEEK_SET) != 0)
    {
     sql_err_code = -222L;
     printf ("Error: could not position in file '%s'\n", file);
    }
}



static void fetch_cursor (void)
/****  read data  ****/
{
  struct LEV_RESULT l_res;
  int  i,k;
  char *s,text[201];

  while (! feof (fr_test))
    {
     db_matchcode = ftell (fr_test);
     strcpy (text,"");

     if (fgets (text,200,fr_test) == NULL)
       {
        /****  error  ****/
        sql_err_code = -222L;
        if (feof (fr_test))
          {
           /****  end of data file  ****/
           sql_err_code = SQL_NOT_FOUND;
          }
        return;
       }

     if (text[0] == '#')
       {
        /****  comment found  ****/
        continue;
       }

     i = (int) strlen (text);

     if (i > 0  &&  text[i-1] == '\n')
       {
        i--;
        if (i > 0  &&  text[i-1] == '\r')
          {
           i--;
          }
        text[i] = '\0';
       }

     if (i == 0)
       {
        /****  empty line  ****/
        continue;
       }

     /****  read "database" fields  ****/
     for (k=0; dummy_db_addr[k].text != NULL; k++)
       {
        strcpy (dummy_db_addr[k].text,"");
       }

     s = text; 
     k = 0;
     for (i=0; text[i] != '\0'; i++)
       {
        if (text[i] == ';')
          {
           text[i] = '\0';
           StrNCpy (dummy_db_addr[k].text, s, dummy_db_addr[k].info +1);
           text[i] = ';';

           s = text + i+1;
           k++;
           if (dummy_db_addr[k].text == NULL)
             {
              break;
             }
          }
       }

#ifdef SPLIT_FULL_BIRTHDAY
     split_birthday (db_full_birthday, NULL,
                db_b_day, db_b_month, db_b_year);
#endif


     /****  look for match  ****/
     i = COMPARE_NORMAL | DB_WILDCARDS_FOR_LIKE;

     l_res = lev_x (s1_fam_name, db_fam_name, "",0, i);
     if (l_res.diff > 0)
       {
        l_res = lev_x (s2_fam_name, db_fam_name, "",0, i);
       }
     if (l_res.diff > 0)
       {
        l_res = lev_x (s3_fam_name, db_fam_name, "",0, i);
       }
     if (l_res.diff > 0)
       {
        l_res = lev_x (s4_fam_name, db_fam_name, "",0, i);
       }
     if (l_res.diff > 0)
       {
        l_res = lev_x (s_zip_code, db_zip_code, "",0, i);
       }
     if (l_res.diff > 0)
       {
        l_res = lev_x (s_cust_number, db_cust_number, "",0, i);
       }

     if (l_res.diff == 0)
       {
        sql_err_code = SQL_SUCCESS;
        return;
       }
    }

  sql_err_code = SQL_NOT_FOUND;
}


static void close_cursor (void)
{
 sql_err_code = SQL_SUCCESS;
}

#endif

/********************************************************/
/****  end of file "dummy_db.h"  ************************/
/********************************************************/
