File  : s_mod11.c    (in German)
Author: Jrg Michael, Hannover, Germany

Check sums based on mod 11
(program from c't, issue 07/1996)

Contents:
1. Documentation for program "mod11.c" (in German)
2. C programm "mod11.c"


/*-------------------------------------------*/


(in German:)


Dokumentation zu "mod11.c":

Prfung von beliebig langen Zahlenfeldern mittels 
Modulo 11-Verfahren gem [Verhoeff].


Grundlage des Verfahrens:
Da 11 eine Primzahl ist, ist 2 eine so genannte zehnte primitive
Einheitswurzel von 11. Es gilt also:
2 hoch 10 == 1  (mod 11)


Theorie:
Die Prfziffer wird so berechnet, dass gilt:
Summe ((2 hoch n) * a n) == 0   (mod 11)


Nachteil dieses Verfahrens:

Da der Rest "10" vorkommen kann, muss man sich entscheiden, 
ob in solchen Fllen ersatzweise ein Buchstabe als "elfte Ziffer" 
genommen wird.
Falls dies nicht gewnscht ist, drfen die entsprechenden Zahlen
nicht benutzt werden.



Erkannte Fehler:

einfache Fehler      :  alle Fehler erkannt
Nachbarvertauschungen:  alle Fehler erkannt
phonetische Fehler   :  alle Fehler erkannt

Zwillingsvertauschung:  alle Fehler erkannt
Sprungtranspositionen:  alle Fehler erkannt
Sprung-Zwillingsvert.:  alle Fehler erkannt

sonstige Fehler      :   90,0 % (geschtzt)



Literatur:

J. Verhoeff: Error Detecting Decimal Codes, Mathematical Centre Tracts, 
Vol. 29 (Mathematisch Centrum, Amsterdam, 1969).

R.-H. Schulz: Codierungstheorie. Eine Einfhrung, Vieweg Verlag, 
Braunschweig, Wiesbaden, 1991 (siehe Kapitel 8: Prfzeichenverfahren).

J. Michael, Mit Sicherheit, Prfziffernverfahren auf Modulo-Basis, 
c't, Heft 07/1996, S. 264-268.

J. Michael, Bltenrein, Prfziffernverfahren auf der Basis von 
Diedergruppen, c't, Heft 04/1997, S. 448-452.


/*-------------------------------------------*/


/****  Datei:  mod11.c                ****/ 
/****  Berechnung von Prfziffern     ****/ 
/****     mittels Modulo 11           ****/ 
/****  Autor: Jrg Michael, Hannover  ****/ 
/****     c't, 07/1996, S. 264-268    ****/ 

#include <stdio.h> 
#include <ctype.h> 
#include <string.h> 

/****  Optionen  ****/ 
#define  setze_pruefziffer 
#define  loesche_trenner 
#define  trennzeichen     "/ -.:" 
#define  elfte_ziffer     'X' 

/****  Fehlercodes  ****/ 
#define  ZAHL_ZU_KURZ     -1000 
#define  ZAHL_ZU_LANG     -2000 
#define  UNGUELTIGE_PARAMETER  -3000 
#define  ZAHL_NICHT_VERWENDEN  -5000 
/****  Zahl nicht verwenden wg. Rest 10  ****/ 
/****  (nur bei "#undef elfte_ziffer")   ****/ 

/****  Potenzen von 2 (Modulo 11)  ****/ 
int zwei_hoch[10] = { 2, 4, 8, 5, 10, 9, 7, 3, 6, 1 }; 

/****  multiplikative Inverse bzgl. Modulo 11  ****/ 
int inv_mod11 [11] = { 0, 1, 6, 4, 3, 9, 2, 8, 7, 5, 10 }; 



int hole_mod11 (char zahl[], int anz_ziff, int pos) 
/****  Bestimmt bzw. setzt die Prfziffer einer Zahl.  ****/ 
/****  Ergebnis: Prfziffer im Bereich '0' bis '9'     ****/ 
/****            bzw. das Zeichen "elfte_ziffer"       ****/ 
{ 
 int i=0,k=0,n=0; 
 int p = -1; 
 int s = 0; 
 if (anz_ziff > 0  &&  pos >= anz_ziff) 
   { 
    return (UNGUELTIGE_PARAMETER); 
   } 

 /****  Prfsumme ohne "pos" bestimmen  ****/ 
 while ((k = (int) zahl[n]) != 0) 
   { 
#ifdef trennzeichen 
    if (strchr (trennzeichen,k) != NULL) 
      { 
  #ifdef loesche_trenner 
       strcpy (zahl+n, zahl+n+1); 
  #else 
       n++; 
  #endif 
       continue; 
      } 
#endif 
    if (isdigit (k)  &&  i != pos) 
      { 
       s += zwei_hoch [i%10] * (k-'0'); 
       n++; 
       i++; 
      } 
    else if (i == pos  ||  pos < 0) 
      { 
       pos = i; 
       p = n; 
       n++; 
       i++; 
      } 
    else 
      { 
       break; 
      } 
   } 

 /****  Fehlerprfung  ****/ 
 if (zahl[n] != 0  &&  zahl[n] != ' ') 
   { 
    /****  Die (i+1)-te Ziffer ist fehlerhaft  ****/ 
    return (-i-1); 
   } 
 if (i <= 1  ||  i < anz_ziff  ||  p < 0) 
   { 
    return (ZAHL_ZU_KURZ); 
   } 
 if (anz_ziff > 0  &&  i > anz_ziff) 
   { 
    return (ZAHL_ZU_LANG); 
   } 
 /****  Prfziffer berechnen aus der Bedingung:  ****/ 
 /****   (s + 2^(pos+1) * x) % 11 = 0            ****/ 
 n = zwei_hoch [pos%10]; 
 s = s % 11;   /****  wichtig wg. Computerarithmetik  ****/ 
 k = ((11-s) * inv_mod11[n]) % 11; 

 if (k < 10) 
   { 
    i = (k+'0'); 
   } 
 else 
   { 
  #ifdef elfte_ziffer 
     i = elfte_ziffer; 
  #else 
     /****  Zahl nicht verwenden wg. Rest 10  ****/ 
     return (ZAHL_NICHT_VERWENDEN); 
  #endif 
   } 
#ifdef setze_pruefziffer 
  /****  Prfziffer setzen  ****/ 
  zahl[p] = i; 
#endif 
 return (i); 
} 

#ifdef elfte_ziffer 
 int check_mod11 (char zahl[], int anz_ziff, int pos) 
#else 
 int check_mod11 (char zahl[], int anz_ziff) 
#endif 
/****  Prft eine Zahl auf Plausibilitt     ****/ 
/****  Ergebnis:  0 : kein Fehler erkennbar  ****/ 
/****           1-10: Prfsumme fehlerhaft   ****/ 
{ 
 int i=0,k=0, 
     n=0,s=0; 
#ifdef elfte_ziffer 
 if (anz_ziff > 0  &&  pos >= anz_ziff) 
   { 
    return (UNGUELTIGE_PARAMETER); 
   } 
#endif 

 while ((k = (int) zahl[n]) != 0) 
   { 
#ifdef trennzeichen 
    if (strchr (trennzeichen,k) != NULL) 
      { 
  #ifdef loesche_trenner 
       strcpy (zahl+n, zahl+n+1); 
  #else 
       n++; 
  #endif 
       continue; 
      } 
#endif 
#ifdef elfte_ziffer 
    if (k == elfte_ziffer  &&  (pos < 0  ||  i == pos)) 
      { 
       pos = i; 
       s += zwei_hoch [i%10] * 10; 
       n++; 
       i++; 
       continue; 
      } 
#endif 

    if (isdigit (k)) 
      { 
       s += zwei_hoch [i%10] * (k-'0'); 
       n++; 
       i++; 
      } 
    else 
      { 
       break; 
      } 
   } 

 /****  Fehlerprfung  ****/ 
 if (zahl[n] != 0  &&  zahl[n] != ' ') 
   { 
    /****  Die (i+1)-te Ziffer ist fehlerhaft  ****/ 
    return (-i-1); 
   } 
 if (i < anz_ziff) 
   { 
    return (ZAHL_ZU_KURZ); 
   } 
 if (anz_ziff > 0  &&  i > anz_ziff) 
   { 
    return (ZAHL_ZU_LANG); 
   } 
 return (s % 11); 
} 
