#!/bin/sh
#
# einfache Paketfilterregeln für IPv6
# nutzt das conn_track-Modul, das ab
# Kernel 2.6.20 aus- und eingehende 
# Verbindungen überwachen kann
#
# Reiko Kaps <rek@ctmagazin.de> 2008
#
# Referenzen:
# http://www.sixxs.net/wiki/IPv6_Firewalling
# http://mirrors.deepspace6.net/Linux+IPv6-HOWTO-de/chapter-firewalling-security.html
ip6tables -P INPUT ACCEPT
ip6tables -P OUTPUT ACCEPT
ip6tables -P FORWARD ACCEPT
ip6tables -A FORWARD -s ff00::/8 -j ACCEPT
ip6tables -A FORWARD -s fe80::/10 -j ACCEPT
ip6tables -A INPUT -p tcp --dport 22 -j ACCEPT
ip6tables -A INPUT -m state --state ESTABLISHED,RELATED -j ACC
ip6tables -A FORWARD -m state --state ESTABLISHED,RELATED -j A
ip6tables -A FORWARD -s '!' 2001:db8::/64 -j DROP
ip6tables -A INPUT -s '!' 2001:db8::/64 -j DROP


FW="/sbin/ip6tables"

## Router-Einstellungen
function ipv6_router()
{
    # Forwarding für alle Netzwerkkarten aktivieren, erledigt auch radvd unter
		# Debian und Ubuntu
    # echo "1" >/proc/sys/net/ipv6/conf/all/forwarding
    
    # Vorgaben 
    $FW -P INPUT ACCEPT
    $FW -P OUTPUT ACCEPT
    $FW -P FORWARD ACCEPT

    # linklocale Adressen, Multicast und ICMP erlauben
    # wenn sie aus dem lokalen Netz kommen
    $FW -A FORWARD -s ff00::/8 -j ACCEPT
    $FW -A FORWARD -s fe80::/10 -j ACCEPT
    # $FW -A FORWARD -p icmpv6 -j ACCEPT

    # SSH-Port des Routers öffnen
    # ip6tables -A INPUT -p tcp --dport 22 --jump ACCEPT

    # aus dem Netz oder vom Router aufgebaute Verbindungen akzeptieren
    $FW -A INPUT -m state --state ESTABLISHED,RELATED -j ACCEPT
    $FW -A FORWARD -m state --state ESTABLISHED,RELATED -j ACCEPT

    # ICMPv6-Rate begrenzen
    $FW -A INPUT --protocol icmpv6 --icmpv6-type echo-request -j ACCEPT --match limit --limit 30/minute 
    
    # Beispiele (bitte eigenen Präfix eintragen!!!)
    $FW -A FORWARD -s '!' 2001:db8:123::/48 -j DROP
    $FW -A INPUT -s '!' 2001:db8:123::/48 -j DROP
    
}

## Desktop-Einstellungen
function common()
{
    # Vorgaben für alle Pakete:
    # eingehende und weitervermittelte verwerfen, 
    # ausgehende akzeptieren
    $FW -P INPUT   ACCEPT
    $FW -P FORWARD ACCEPT
    $FW -P OUTPUT  ACCEPT
    
    # Pakete akzeptieren, die zu Verbindungen gehören, 
    # die von innen aufgebaut wurden
    $FW -A INPUT -m state --state ESTABLISHED,RELATED -j ACCEPT
    $FW -A FORWARD -m state --state ESTABLISHED,RELATED -j ACCEPT

    # ICMPv6-Rate begrenzen
    $FW -A INPUT --protocol icmpv6 --icmpv6-type echo-request -j ACCEPT --match limit --limit 30/minute    
}

## Main
case "$1" in
    start-*)
	# sicherheitshalber alles löschen
	$0 stop
	
	case "$1" in
	    start-router)
			ipv6_router
			;;
	    start-desktop)
			common
			;;
	esac  
	;;
    stop)
	# Forwarding für alle Netzwerkkarten deaktivieren ,
	# erledigt unter Debian auch /etc/init.d/radvd
	# echo "0" >/proc/sys/net/ipv6/conf/all/forwarding
	
	# Vorgaben zurücksetzen
	$FW -P INPUT   ACCEPT
	$FW -P FORWARD ACCEPT
	$FW -P OUTPUT  ACCEPT
	
	# alle anderen Regeln löschen
	$FW -F -v 
	;;
    block)
	# Vorgaben 
	$FW -P INPUT   DROP
	$FW -P FORWARD REJECT
	$FW -P OUTPUT  DROP
	
	# alle anderen Regeln löschen
	$FW -F -v 	
	;;
    list)
	# ausführliche Anzeige der Regeln und Vorgaben
	$FW -n -v --line-numbers -L 
	;;
    *)
	echo "usage: $0 start-router|start-desktop|stop|block|list"
	;;
esac
