#!/bin/bash

DialogCmds="/usr/bin/kdialog /usr/bin/zenity /usr/bin/dialog"

Dmap='	--msgbox;--msgbox "${2}" 0 0'\
'	--textbox;--textbox "${2}" 0 0'\
'	--yesno;--yesno "${2}" 0 0'\
'	--menu;--menu "${2}" 0 0 0 "${@:3}"'\
'	--checklist;--checklist "${2}" 0 0 0 "${@:3}"'\
'	--radiolist;--radiolist "${2}" 0 0 0 "${@:3}"'\
'	--inputbox;--inputbox "${2}" 0 0'\
'	--password;--passwordbox "${2}" 0 0'

Zmap='	--msgbox;--info --text "${2}"'\
'	--textbox;--text-info --filename="${2}"'\
'	--yesno;--question --text "${2}"'\
'	--menu;--list --column "" --column "" --text "${2}" "${@:3}"'\
'	--checklist;--list --checklist --column "" --column "" --column "" --text "${2}" "${@:3}"'\
'	--radiolist;--list --radiolist --column "" --column ""--column "" --text "${2}" "${@:3}"'\
'	--inputbox;--entry --text "${2}"'\
'	--password;--entry --hide-text --text "${2}"'

for d in ${DialogCmds}; do
  if [ -x "${d}" ]; then
    Dcmd=${d}
    break
  fi
done

if [ -z "${Dcmd}" ]; then
  echo "None of the supported dialog programms found:"
  echo "  ${DialogCmds}"
  exit 1
fi

function adialog()
{
  case ${Dcmd##*/} in
    "dialog")
      Cmd="${Dmap#*$'\t'${1};}"
      if [ ${#Cmd} -eq ${#Dmap} ]; then
        Cmd="${1} "
      else
        Cmd="${Cmd%%$'\t'*}"
      fi
      ;;
    "kdialog")
      Cmd="${@}"
      ;;
    "zenity")
      # Kommando aus $1 umwandeln
      Cmd="${Zmap#*$'\t'${1};}"
      if [ ${#Cmd} -eq ${#Zmap} ]; then
        Cmd="${1} ${@}"
      else
        Cmd="${Cmd%%$'\t'*}"
      fi
      ;;
    *)
      echo "Unsupported dialog programm ${Dcmd}"
      exit 1
  esac
  eval ${Dcmd} ${Cmd} 2>&1
  return $?
}

#adialog --msgbox Test
#adialog --textbox /etc/fstab
#adialog --yesno Test
adialog --menu Test 1 Eins 2 Zwei 3 Drei
#adialog --inputbox Test
#adialog --password Test1
