<?
/******************************************************************************
** This file is part of the PMWiki extension media2mult.                     **
** Copyright (c) 2005-2008 Zentrum virtUOS, University of Osnabrck, Germany **
**                                                                           **
** This program is free software; you can redistribute it and/or             **
** modify it under the terms of the GNU General Public License               **
** as published by the Free Software Foundation; either version 2            **
** of the License, or (at your option) any later version.                    **
**                                                                           **
** This program is distributed in the hope that it will be useful,           **
** but WITHOUT ANY WARRANTY; without even the implied warranty of            **
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
** GNU General Public License for more details.                              **
**                                                                           **
** You should have received a copy of the GNU General Public License         **
** along with this program; if not, write to the Free Software               **
** Foundation, Inc., 51 Franklin Street, Fifth Floor,                        **
** Boston, MA 02110-1301, USA.                                               **
*******************************************************************************/

require_once 'debugfuncs.php';

class StylesheetOptions {	
	// "private" variables; don't use them directly!
	var $currentCategory;
	var $currentOption;
	var $currentTag;
	var $options;
	var $categories;
	var $dir;         // dirname of read XML file (used for includes)
	var $arrayIndex;

	function StylesheetOptions ($fname='') {
		$this->options = array();
		$this->categories = array();
		$this->currentCategory = array();
		$this->currentTag = false;
		$this->arrayIndex = false;
		if ($fname)
			$this->readXML($fname);
	}

	
	/** Reads a set of options from an XML file. 
	 *  @param fname name of XML file to be read */	
	function readXML ($fname) {
		$parser = xml_parser_create();
		xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, false);
		xml_set_element_handler($parser, array(&$this, "beginElement"), array(&$this, "endElement"));
		xml_set_character_data_handler($parser, array(&$this, "characterData"));
		$xmlfile = @fopen($fname, "r");
		if ($xmlfile === false)
			return false;
		$this->dir = dirname($fname);
		while ($data = fread($xmlfile, 4096))
			if (!xml_parse($parser, $data, feof($xmlfile)))
				die(sprintf("xml error: %s at line %d of file '$fname'", xml_error_string(xml_get_error_code($parser)), xml_get_current_line_number($parser)));
		fclose($xmlfile);
		xml_parser_free($parser);
		return true;
	}

	
	/** Creates an XML file out of the current option set. 
	 *  @param fname name of XML file to be written */	
	function writeXML ($fname) {
		$xmlfile = fopen($fname, "w");
		fwrite($xmlfile, '<?xml version="1.0" encoding="ISO-8859-1"?>' . "\n");
		fwrite($xmlfile, '<!-- This file was automatically generated by media2mult. -->' . "\n");
		fwrite($xmlfile, '<!-- Don\'t modify it manually.  -->' . "\n");
		fwrite($xmlfile, '<!-- (c) Universitaet Osnabrueck, Zentrum virtUOS  -->' . "\n");
		fwrite($xmlfile, "<options>\n");
		foreach ($this->categories as $c) {
			fwrite($xmlfile, "  <section title=\"$c[title]\">\n");
			foreach ($c['options'] as $o) {
				fwrite($xmlfile, "    <option name=\"$o[name]\" type=\"$o[type]\" target=\"$o[target]\" >\n");
				fwrite($xmlfile, "      <description>$o[description]</description>\n");
				fwrite($xmlfile, "      <value>$o[value]</value>\n");
				fwrite($xmlfile, "    </option>\n");
			}
			fwrite($xmlfile, "  </section>\n");
		}			
		fwrite($xmlfile, "</options>\n");
		fclose($xmlfile);
	}

	function writeShortXML ($fname) {
		$xmlfile = fopen($fname, "w");
		fwrite($xmlfile, '<?xml version="1.0" encoding="ISO-8859-1"?>' . "\n");
		fwrite($xmlfile, '<!-- This file was automatically generated by media2mult. -->' . "\n");
		fwrite($xmlfile, '<!-- Don\'t modify it manually.  -->' . "\n");
		fwrite($xmlfile, '<!-- (c) Universitaet Osnabrueck, Zentrum virtUOS  -->' . "\n");
		fwrite($xmlfile, "<options>\n");
		foreach ($this->options as $o) {
			if (is_array($o['value'])) {
				fwrite($xmlfile, "<short-option name='$o[name]'>\n");
				foreach ($o['value'] as $k=>$v) 
					fwrite($xmlfile, "<entry $o[indexname]='$k'>$v</entry>\n");
				fwrite($xmlfile, "</short-option>\n");
			}
			else
				fwrite($xmlfile, "<short-option name='$o[name]'>$o[value]</short-option>\n");
		}
		fwrite($xmlfile, "</options>\n");
		fclose($f);
	}


	function writeStylesheet ($fname, $parentStylesheet) {
		$f = fopen($fname, "w");
		if (!$f)
			return false;
		fwrite($f, '<?xml version="1.0" encoding="ISO-8859-1"?>' . "\n");
		fwrite($f, '<!-- This file was automatically generated by media2mult. -->' . "\n");
		fwrite($f, '<!-- Don\'t modify it manually.  -->' . "\n");
		fwrite($f, '<!-- (c) Universitaet Osnabrueck, Zentrum virtUOS  -->' . "\n");
		fwrite($f, '<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">'."\n");
		fwrite($f, "<xsl:import href='$parentStylesheet'/>\n");
		fwrite($f, '<xsl:output method="xml" encoding="ISO-8859-1"/>'."\n");
		foreach ($this->options as $o) {
			if (is_array($o['value'])) {
				fwrite($f, "<xsl:param name='$o[name]'>\n");
				foreach ($o['value'] as $k=>$v) 
					fwrite($f, "<entry $o[indexname]='$k'>$v[value]</entry>\n");
				fwrite($f, "</xsl:param>\n");
			}
			else {
				fwrite($f, "<xsl:param name=\"$o[name]\" select=\"");
				$quote = strpos(" enum string length", substr($o['type'],0,4)) ? "'" : "";
				fwrite($f, "$quote$o[value]$quote\"/>\n");
			}
		}
		fwrite($f, "</xsl:stylesheet>\n");
		fclose($f);
		return true;
	}


	// "static" function
	function copyXML ($source, $target) {
		$options = new StylesheetOptions($source);
		if (is_object($options))
			$options->writeXML($target);
	}

	
	function getCategories () {
		return $this->categories;
	}


	function getOptions () {
		return $this->options;
	}


	function setRequestValues ($values) {
		foreach ($this->options as $o) {
			$val = $values[str_replace(".", "_", $o['name'])]; 
			if ($o['type'] == 'file' && $o['value'] != '' && $val == '')
				continue;
			if ($o['type'] == 'bool')      // unchecked checkboxes are not submitted by POST
				$val = $val == "" ? 0 : 1;  // only checked checkboxes submit a (former) value "false"
			$this->setValue($o['name'], $val);
		}
	}

	function getType ($optionName) {	
		if (array_key_exists($optionName, $this->options))
			return $this->options[$optionName]["type"];
		return false;
	}
	
	/** Returns the current value of a given option. */
	function getValue ($optionName) {
		if (array_key_exists($optionName, $this->options))
			return $this->options[$optionName]["value"];
		return false;
	}

	/** Sets the value of a given option
	 *  @return true if value could be assigned */
	function setValue ($optionName, $value) {
		if (array_key_exists($optionName, $this->options)) {
			$this->options[$optionName]["value"] = $value;
			return true;
		}
		return false;
	}



	/** Returns the section of a given option. If there is no option
	 *  with such a name false is returned. */
	function getSection ($optionName) {
		foreach ($categories as $c) 
			if (array_key_exists($optionName, $c["options"]))
				return $c;
		return false;
	}

	function show () {
		echo "<table>\n";
		echo '<tr bgcolor="#808080"><td><b>Name</b></td><td><b>Type</b></td><td><b>Description</b></td><td><b>Value</b></td></tr>';
		foreach ($this->options as $o)
			echo "<tr bgcolor=\"#c0c0c0\"><td>$o[name]</td><td>$o[type]</td><td>$o[description]</td><td>$o[value]</td></tr>\n";
		echo "</table>\n";
	}
	

   /////////////////////////////////////////
  ///        private functions	       ///
 ///    don't call them directly !     ///
/////////////////////////////////////////	
	

	/** This function is called by the XML parser if an opening XML tag has been read. 
	 *  @param $parser handle of parser that called this function
	 *  @param $name   name of XML tag: $name == foo if <foo> was read 
	 *  @param $attribs array of attributes specified within the tag */
	function beginElement ($parser, $name, $attribs) {
		$this->currentTag = $name;
		if ($name == "section") 
			$this->currentCategory = array("title" => $attribs['title'], "options" => array());
		elseif ($name == "option") {
			$type = trim($attribs['type']);
			if (preg_match('/array\[(.+?):(.+?)]/', $type, $m)) {
				$this->currentOption = array(
					'name' => $attribs['name'],
					'type' => $attribs['type'],
					'indexname' => $m[1],
					'indexdescr'=> $m[2],
					'value'=> array()
				);
			}
			else {
				$this->currentOption = array(
					'name' => $attribs['name'], 
					'type' => $attribs['type']
				);
			}
		}
		elseif ($name == "short-option") {
			$name = trim($attribs['name']);
			$this->currentOption = &$this->options[$name];
			// delete current value
			if (is_array($this->currentOption['value']))
				foreach ($this->currentOption['value'] as &$v)
					$v['value'] = '';
			else
				$this->currentOption['value'] = "";
			$this->currentTag = 'value';
		}
		elseif ($name == "entry") {
			$this->arrayIndex = $attribs[$this->currentOption['indexname']];
			if (isset($attribs['type']))
				$this->currentOption['value'][$this->arrayIndex]['type'] = $attribs['type'];
		}
		elseif ($name == 'include') {
			if ($fname{0} != '/' && $this->dir != '')
				$fname = "{$this->dir}/$attribs[file]";
			if (file_exists($fname))
				$this->readXML($fname);
			else
				message("option file '$fname' not found");
		}
	}


	/** This function is called by the XML parser if an closing XML tag has been read. 
	 *  @param $parser handle of parser that called this function
	 *  @param $name   name of XML tag: $name == foo if </foo> was read */
	function endElement ($parser, $name) {
		$this->currentTag = false;
		if ($name == "option") {			
			$this->options[$this->currentOption["name"]] = $this->currentOption;
			array_push($this->currentCategory["options"], &$this->options[$this->currentOption["name"]]);
			unset($this->currentOption);
		}
		elseif ($name == 'short-option') {
			unset($this->currentOption);  // Referenz auflsen
		}
		elseif ($name == "section") {
			$this->categories[$this->currentCategory["title"]] = $this->currentCategory;
			$this->currentCategory = false;
		}
		elseif ($name == 'entry')
			$this->arrayIndex = false;
	}

	
	/** This function is called by the XML parser if plain text outside of 
	 *  angle brackets has been read. */
	function characterData ($parser, $data) {		
		if (preg_match('/^\s*$/', $data)) 
			return;
		if (substr(phpversion(), 0, strpos(phpversion(), '.')) == 5) 
			$data = utf8_decode($data);   // fix buggy behavior of PHP 5
//		$data = htmlentities($data);
		if ($this->currentTag == "value") {
			if ($this->arrayIndex === false)
				$this->currentOption["value"] .= $data;
		}
		elseif ($this->currentTag == 'entry') {
			if ($this->arrayIndex !== false)
				$this->currentOption['value'][$this->arrayIndex]['value'] .= $data;
		}
		elseif ($this->currentTag == "description") 
			$this->currentOption["description"] .= $data;
	}
}


?>
