import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;


import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;


public class MobileFishCanvas extends GameCanvas implements Runnable {

    private Thread gameLoop;
    private MobileFish midlet;
    private static final int MILLIS_PER_TICK = 50;
    
    private Sprite freddy;
    private Sprite heart;
    private Sprite key;
    private Sprite star;
    private Sprite background;
    private TiledLayer stones;
    private int power = 100;
    
    LayerManager layerManager;
    Camera camera;

    public MobileFishCanvas(MobileFish aMIDlet) throws IOException {
        super(true); //true: Key-Events unterdrcken
        midlet = aMIDlet;
        init();
    }

    private void init() throws IOException {
 
        //LayerManager
	layerManager = new LayerManager();
         
        //Freddy
        freddy = new Sprite(Image.createImage("/Freddy.png"));
        freddy.setPosition(16,184);
        layerManager.append(freddy);
	     
        //Herz initialisieren
	heart = new Sprite(Image.createImage("/Heart.png"));
	heart.setPosition(100,100);
	layerManager.append(heart);
	   	
	//Gegner Stern initialisieren
	star = new Sprite(Image.createImage("/Star.png"));
	star.setPosition(120,120);
	layerManager.append(star);
				
	//Ziel - Schlssel
	key = new Sprite(Image.createImage("/Key.png"));
	key.setPosition(100,10);
        layerManager.append(key); 
         //Hintergrund
	background = new Sprite(Image.createImage("/Background.png"));
        
        //Tiled - Hintergrung initialisieren
	stones = new TiledLayer(16,16,Image.createImage("/Stone_Tiles.png"),16,16);
		
        int[][] tiles = {
                        {7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 8},
                        {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
                        {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
                        {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
                        {5, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 6},
                        {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
                        {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
                        {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
                        {9, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 4},
                        {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
                        {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
                        {5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4},
                        {5, 0, 0, 0, 0, 0, 0, 0, 0, 6, 7, 7, 7, 7, 7, 7},
                        {5, 0, 0, 0, 0, 0, 0, 6, 7, 7, 7, 7, 7, 7, 7, 7},
                        {5, 0, 0, 0, 0, 0, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7},
                        {0, 3, 3, 3, 3, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7}
            };
		
        for(int i =0;i<16;i++){	
            for(int j= 0;j<16;j++){
        	stones.setCell(j,i,tiles[i][j]);
            }
        }
        
	layerManager.append(stones);
	layerManager.append(background);
        
        //Kamera
        camera = new Camera(this,background);
    }

    protected void showNotify() {
        gameLoop = new Thread(this);
        gameLoop.start();
    }

    protected void hideNotify() {
        gameLoop = null;
    }

    public void run() {
        Thread t = Thread.currentThread();

        while (t == gameLoop) {
            long startTime = System.currentTimeMillis();
            update();
            render();
            flushGraphics();
            long timeTaken = System.currentTimeMillis() - startTime;

            if (timeTaken < MILLIS_PER_TICK) { // etwas warten, damit andere auch dran kommen
                try {
                    Thread.sleep(MILLIS_PER_TICK - timeTaken);
                } catch (InterruptedException ex) {
                    //Fehlerbehandlung
                }
            }
        }
    }
    
    private int update() {
        /* Korrekt wre hier: private  void  update
         * Dies fhrt aber bei einigen Handys (z.B. Nokia)
         * zum Programmabsturz. 
         * Siehe auch: http://discussion.forum.nokia.com/forum/showthread.php?t=53435
         * Deshalb der Workaround mit private  int  update()
         */
       
        // Fisch bewegen
        int keyStates = getKeyStates();
        
        int freddyLastX = freddy.getX();
        int freddyLastY = freddy.getY();
        int speed = 2;
        
        if ((keyStates & GameCanvas.LEFT_PRESSED) != 0) {
            freddy.move(-1 * speed, 0);
            freddy.setTransform(Sprite.TRANS_MIRROR);
        } else if ((keyStates & GameCanvas.RIGHT_PRESSED) != 0) {
            freddy.move(speed, 0);
            freddy.setTransform(Sprite.TRANS_NONE);
        } else if ((keyStates & GameCanvas.UP_PRESSED) != 0) {
            freddy.move(0,-1*speed);
        } else if ((keyStates & GameCanvas.DOWN_PRESSED) != 0) {
            freddy.move(0,speed);
        }
        
        //Zusammensto mit Felsen
        if (freddy.collidesWith(stones,true)){
            freddy.setPosition(freddyLastX, freddyLastY);
            power-=1;
        }
        
        //Zusammensto mit Herz
        if (freddy.collidesWith(heart,true)){
            heart.setVisible(false);  //collidesWith nur, wenn visible
            power+=50;
        }
        
        //Zusammensto mit Star (Feind)
        if (freddy.collidesWith(star,true)){
            power-=40;
        }
	
        //Layermanager "Kamera" positionieren
        camera.move(freddy.getX(),freddy.getY());    
        
        //Spiel beenden
        if(freddy.collidesWith(key,true)){
            stopGame();   //Gewonnen !!!!!!!!
        }

        if (power<1) stopGame();  //Verloren !!!!!!!!
        
        return 0;
    }
    
    private void stopGame(){
        midlet.quit();
    }
    
    private void render() {
        Graphics g = getGraphics();
        
        layerManager.setViewWindow(camera.x, camera.y, getWidth(), getHeight());
        layerManager.paint(g,0,0);
        
	g.setColor(255,255,255);
	g.drawString("Power: " + power,getWidth(),0,Graphics.TOP | Graphics.RIGHT);
    }

    
}
