#!/bin/bash
#
# Reiko Kaps <rek@ctmagazin.de> 2008
#
# @see man ssh. man ssh_config
# @see man ifconfig, man route

##########################################
# SSH-Server, Schlüsseldatei
# BITTE anpassen !!!!!!!!!!!
HOST_NAME=router2
HOST_PORT=54321
KEYFILE=$HOME/.ssh/id_rsa-vpn

##########################################
# Tunnel-Interface
TUN_LOCAL=0
TUN_REMOTE=0

##########################################
# Transportnetz
IPTUN_LOCAL=10.10.10.1
IPTUN_REMOTE=10.10.10.2
IPTUN_NETMASK=255.255.255.252

##########################################
# entferntes LAN (hinter Router 2)
REMOTE_LAN=192.168.1.0
REMOTE_NETMASK=255.255.255.0

##########################################
# lokales LAN (hinter diesem Rechner)
LOCAL_LAN=10.10.222.0
LOCAL_NETMASK=255.255.255.0

##########################################
# Sonstiges, muss nicht angepasst werden
SOCKET=/var/run/ssh-meinvpn-tunnel.pid


##########################################
# Programm, Tunnelaufbau und Netzwerk-
# einrichtung ...
##########################################


case $1 in 
    start)
	echo " * Starting VPN-Tunnel ... "
	
	modprobe tun

	ssh -S ${SOCKET} -o 'TCPKeepAlive yes' -M -f -w ${TUN_LOCAL}:${TUN_REMOTE} \
	    -i ${KEYFILE} -p ${HOST_PORT} ${HOST_NAME} "\
ifconfig tun${TUN_REMOTE} ${IPTUN_REMOTE} pointopoint ${IPTUN_LOCAL} netmask ${IPTUN_NETMASK} \
&& route add -net ${REMOTE_LAN} netmask ${REMOTE_NETMASK} gw ${IPTUN_LOCAL} tun${TUN_REMOTE} \
&&  echo 1 > /proc/sys/net/ipv4/ip_forward \
&& true"

	sleep 5

	echo " * Richte tun${TUN_LOCAL} und das Routing ein ..." 
        # lokale Netzwerkeinrichtung/Routing ...
	ifconfig tun${TUN_LOCAL} ${IPTUN_LOCAL} pointopoint ${IPTUN_REMOTE} netmask ${IPTUN_NETMASK} 
	route add -net ${REMOTE_LAN} netmask ${REMOTE_NETMASK} gw ${IPTUN_REMOTE} tun${TUN_LOCAL}
	echo "1" > /proc/sys/net/ipv4/ip_forward
	echo " * [DONE]"
	;;
    stop)
	echo " * Stoppe VPN-Tunnel ..."
	ssh -S ${SOCKET} -O exit $HOST_NAME
	echo " * [DONE]"
	;;
    hilfe)
	echo "Das Skript benötigt einen SSH-Server, der"
	echo "eine vollwertigen Root-Zugang erlaubt. Dazu"
	echo "müssen auf dem Server in der Datei" 
        echo "/etc/sshd/sshd_config die Zeilen "
        echo "'PermitRootLogin no' und 'PermitTunnel yes'"
        echo "stehen. Letzterer erlaubt den Tunnelaufbau."
	echo 
	$0 
	exit 0
	;;
    *)
	echo "usage: $0 start|stop|hilfe"	
	exit 0
esac
exit 0