{type:"class",attributes:{"name":"TestClass","packageName":"qx.dev.unit","superClass":"qx.dev.unit.TestSuite","fullName":"qx.dev.unit.TestClass","type":"class"},children:[{type:"desc",attributes:{"text":"<p>This class represents a test suite for a unit test class.</p>\n\n<p>To create your own unit tests, create a class that derives from this one, and\nadd member methods that start with &#8220;test*&#8221;. You can use assertion methods\ninherited from <strong>TestClass</strong> to ease the implementation process.</p>\n\n<p>A simple example:</p>\n\n<pre class=\"javascript\">\nqx. Class.define(\"myapp.test.MyUnitTest\"),\n{\n  extend  : qx.dev.unit.TestCase,\n\n  members :\n  {\n    testMe : function ()\n    {\n      // 'assertEquals' is from the parent\n      this.assertEquals(4, 3+1, \"failure message\");\n    }\n  }\n}\n</pre>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.dev.unit.TestSuite","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"clazz"},children:[{type:"desc",attributes:{"text":"<p>Test class. Must be a sub class of {@link TestCase}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Class"}}]}]}]}]}]},{type:"methods",children:[{type:"method",attributes:{"name":"getName","fromProperty":"name"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>name</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #name}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>name</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initName","fromProperty":"name"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>name</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>name</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #name}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"resetName","fromProperty":"name"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>name</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #name}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setName","fromProperty":"name"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>name</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>name</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #name}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"check":"String","name":"name","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Name of the test suite</p>"}}]}]}]}