{type:"class",attributes:{"name":"IEventHandler","packageName":"qx.event","implementations":"qx.event.handler.Application,qx.event.handler.Object,qx.event.handler.UserAction,qx.event.handler.Appear,qx.event.handler.Keyboard,qx.event.handler.Mouse,qx.event.handler.Capture,qx.event.handler.DragDrop,qx.event.handler.Element,qx.event.handler.Focus,qx.event.handler.Window,qx.ui.core.EventHandler,qx.event.handler.Iframe,qx.event.handler.Input,qx.event.handler.ElementResize,qx.event.handler.DomReady","fullName":"qx.event.IEventHandler","type":"interface"},children:[{type:"desc",attributes:{"text":"<p>Event handler Interface.</p>\n\n<p>All custom event handler like mouse or keyboard event handler must implement\nthis interface.</p>"}},{type:"constants",children:[{type:"constant",attributes:{"type":"Number","name":"TARGET_DOMNODE","value":"1"},children:[{type:"desc",attributes:{"text":"<p>The event target must be a dom node</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"constant",attributes:{"type":"Number","name":"TARGET_OBJECT","value":"3"},children:[{type:"desc",attributes:{"text":"<p>The event target must be a qooxdoo object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"constant",attributes:{"type":"Number","name":"TARGET_WINDOW","value":"2"},children:[{type:"desc",attributes:{"text":"<p>The event target must be a window object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"name":"canHandleEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"target"},children:[{type:"desc",attributes:{"text":"<p>The target to, which the event handler should\n    be attached</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>event type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Whether the event handler can handle events of the given type. If the\nevent handler class has a static variable called <code>IGNORE_CAN_HANDLE</code>\nwith the value <code>true</code> this function is not called. Whether the\nhandler can handle the event is them only determined by the static variables\n<code>SUPPORTED_TYPES</code> and <code>TARGET_CHECK</code>.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the event handler can handle events of the\n    given type.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"registerEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"target"},children:[{type:"desc",attributes:{"text":"<p>The target to, which the event handler should\n    be attached</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>event type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"capture"},children:[{type:"desc",attributes:{"text":"<p>Whether to attach the event to the\n        capturing phase of the bubbling phase of the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method is called each time the an event listener for one of the\nsupported events is added using {@link qx.event.Manager#addListener}.</p>"}}]},{type:"method",attributes:{"name":"unregisterEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"target"},children:[{type:"desc",attributes:{"text":"<p>The target from, which the event handler should\n    be removed</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>event type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"capture"},children:[{type:"desc",attributes:{"text":"<p>Whether to attach the event to the\n        capturing phase of the bubbling phase of the event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method is called each time the an event listener for one of the\nsupported events is removed by using {@link qx.event.Manager#removeListener}\nand no other event listener is listening on this type.</p>"}}]}]}]}