{type:"class",attributes:{"isStatic":"true","name":"Function","packageName":"qx.lang","fullName":"qx.lang.Function","type":"bootstrap"},children:[{type:"desc",attributes:{"text":"<p>Collection of helper methods operating on functions.</p>"}},{type:"methods-static",children:[{type:"method",attributes:{"isStatic":"true","name":"attempt"},children:[{type:"params",children:[{type:"param",attributes:{"name":"func"},children:[{type:"desc",attributes:{"text":"<p>Original function to wrap</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"self"},children:[{type:"desc",attributes:{"text":"<p>The object that the &#8220;this&#8221; of the function will refer to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"varargs"},children:[{type:"desc",attributes:{"text":"<p>The arguments to pass to the function.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"arguments"}}]}]}]},{type:"desc",attributes:{"text":"<p>Tries to execute the function.</p>\n\n<p><strong>Syntax</strong></p>\n\n<pre class=\"javascript\">var result = qx.lang.Function.attempt(myFunction, [self, [varargs...]]);</pre>\n\n<p><strong>Example</strong></p>\n\n<pre class=\"javascript\">\nvar myObject = {\n  'cow': 'moo!'\n};\n\nvar myFunction = function()\n{\n  for(var i = 0; i < arguments.length; i++) {\n    if(!this[arguments[i]]) throw('doh!');\n  }\n};\n\nvar result = qx.lang.Function.attempt(myFunction, myObject, 'pig', 'cow'); // false\n</pre>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<code>false</code> if an exception is thrown, else the function's return."}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}},{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"bind"},children:[{type:"params",children:[{type:"param",attributes:{"name":"func"},children:[{type:"desc",attributes:{"text":"<p>Original function to wrap</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"self"},children:[{type:"desc",attributes:{"text":"<p>The object that the &#8220;this&#8221; of the function will refer to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"varargs"},children:[{type:"desc",attributes:{"text":"<p>The arguments to pass to the function.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"arguments"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns a function whose &#8220;this&#8221; is altered.</p>\n\n<p><strong>Syntax</strong></p>\n\n<pre class=\"javascript\">qx.lang.Function.self(myFunction, [self, [varargs...]]);</pre>\n\n<p><strong>Example</strong></p>\n\n<pre class=\"javascript\">\nfunction myFunction()\n{\n  this.setStyle('color', 'red');\n  // note that 'this' here refers to myFunction, not an element\n  // we'll need to bind this function to the element we want to alter\n};\n\nvar myBoundFunction = qx.lang.Function.bind(myFunction, myElement);\nmyBoundFunction(); // this will make the element myElement red.\n</pre>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The binded function.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"create"},children:[{type:"params",children:[{type:"param",attributes:{"name":"func"},children:[{type:"desc",attributes:{"text":"<p>Original function to wrap</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"name":"options"},children:[{type:"desc",attributes:{"text":"<p>? {Map} Map of options\n<ul>\n<li><strong>self</strong>: The object that the &#8220;this&#8221; of the function will refer to. Default is the same as the wrapper function is called.</li>\n<li><strong>args</strong>: An array of arguments that will be passed as arguments to the function when called.\n    Default is no custom arguments; the function will receive the standard arguments when called.</li>\n<li><strong>delay</strong>: If set, the returned function will delay the actual execution by this amount of milliseconds and return a timer handle when called.\n    Default is no delay.</li>\n<li><strong>periodical</strong>: If set the returned function will periodically perform the actual execution with this specified interval\n     and return a timer handle when called. Default is no periodical execution.</li>\n<li><strong>attempt</strong>: If set to true, the returned function will try to execute and return either the results or false on error. Default is false.</li>\n</ul></p>"}}]}]},{type:"desc",attributes:{"text":"<p>Base function for creating functional closures which is used by most other methods here.</p>\n\n<p><strong>Syntax</strong></p>\n\n<pre class=\"javascript\">var createdFunction = qx.lang.Function.create(myFunction, [options]);</pre>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Wrapped function</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"curry"},children:[{type:"params",children:[{type:"param",attributes:{"name":"func"},children:[{type:"desc",attributes:{"text":"<p>Original function to wrap</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"name":"varargs"},children:[{type:"desc",attributes:{"text":"<p>The arguments to pass to the function.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"arguments"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns a function whose arguments are pre-configured.</p>\n\n<p><strong>Syntax</strong></p>\n\n<pre class=\"javascript\">qx.lang.Function.curry(myFunction, [varargs...]);</pre>\n\n<p><strong>Example</strong></p>\n\n<pre class=\"javascript\">\nfunction myFunction(elem) {\n  elem.setStyle('color', 'red');\n};\n\nvar myBoundFunction = qx.lang.Function.curry(myFunction, myElement);\nmyBoundFunction(); // this will make the element myElement red.\n</pre>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The pre-configured function.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"delay"},children:[{type:"params",children:[{type:"param",attributes:{"name":"func"},children:[{type:"desc",attributes:{"text":"<p>Original function to wrap</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"name":"delay"},children:[{type:"desc",attributes:{"text":"<p>The duration to wait (in milliseconds).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"self"},children:[{type:"desc",attributes:{"text":"<p>The object that the &#8220;this&#8221; of the function will refer to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"varargs"},children:[{type:"desc",attributes:{"text":"<p>The arguments to pass to the function.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"arguments"}}]}]}]},{type:"desc",attributes:{"text":"<p>Delays the execution of a function by a specified duration.</p>\n\n<p><strong>Syntax</strong></p>\n\n<pre class=\"javascript\">var timeoutID = qx.lang.Function.delay(myFunction, [delay, [self, [varargs...]]]);</pre>\n\n<p><strong>Example</strong></p>\n\n<pre class=\"javascript\">\nvar myFunction = function(){ alert('moo! Element id is: ' + this.id); };\n//wait 50 milliseconds, then call myFunction and bind myElement to it\nqx.lang.Function.delay(myFunction, 50, myElement); // alerts: 'moo! Element id is: ... '\n\n// An anonymous function, example\nqx.lang.Function.delay(function(){ alert('one second later...'); }, 1000); //wait a second and alert\n</pre>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The JavaScript Timeout ID (useful for clearing delays).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getCaller"},children:[{type:"params",children:[{type:"param",attributes:{"name":"args"},children:[{type:"desc",attributes:{"text":"<p>The local arguments variable</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"arguments"}}]}]}]},{type:"desc",attributes:{"text":"<p>Extract the caller of a function from the arguments variable.\nThis will not work in Opera.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A reference to the calling function or &#8220;undefined&#8221; if caller is not supported.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}},{type:"entry",attributes:{"type":"undefined"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"getName"},children:[{type:"params",children:[{type:"param",attributes:{"name":"fcn"},children:[{type:"desc",attributes:{"text":"<p>function the get the name for.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"desc",attributes:{"text":"<p>Try to get a sensible textual description of a function object.\nThis may be the class/mixin and method name of a function\nor at least the signature of the function.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Name of the function.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"globalEval"},children:[{type:"params",children:[{type:"param",attributes:{"name":"data"},children:[{type:"desc",attributes:{"text":"<p>JavaScript commands</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Evaluates JavaScript code globally</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Result of the execution</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"listener"},children:[{type:"params",children:[{type:"param",attributes:{"name":"func"},children:[{type:"desc",attributes:{"text":"<p>Original function to wrap</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"self"},children:[{type:"desc",attributes:{"text":"<p>The object that the &#8220;this&#8221; of the function will refer to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"varargs"},children:[{type:"desc",attributes:{"text":"<p>The arguments to pass to the function.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"arguments"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns a function which could be used as a listener for a native event callback.</p>\n\n<p><strong>Syntax</strong></p>\n\n<pre class=\"javascript\">qx.lang.Function.listener(myFunction, [self, [varargs...]]);</pre>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The binded function.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"periodical"},children:[{type:"params",children:[{type:"param",attributes:{"name":"func"},children:[{type:"desc",attributes:{"text":"<p>Original function to wrap</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]},{type:"param",attributes:{"name":"interval"},children:[{type:"desc",attributes:{"text":"<p>The duration of the intervals between executions.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"self"},children:[{type:"desc",attributes:{"text":"<p>The object that the &#8220;this&#8221; of the function will refer to.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"varargs"},children:[{type:"desc",attributes:{"text":"<p>The arguments to pass to the function.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"arguments"}}]}]}]},{type:"desc",attributes:{"text":"<p>Executes a function in the specified intervals of time</p>\n\n<p><strong>Syntax</strong></p>\n\n<pre class=\"javascript\">var intervalID = qx.lang.Function.periodical(myFunction, [period, [self, [varargs...]]]);</pre>\n\n<p><strong>Example</strong></p>\n\n<pre class=\"javascript\">\nvar Site = { counter: 0 };\nvar addCount = function(){ this.counter++; };\nqx.lang.Function.periodical(addCount, 1000, Site); // will add the number of seconds at the Site\n</pre>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The Interval ID (useful for clearing a periodical).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"returnFalse"},children:[{type:"desc",attributes:{"text":"<p>Simply return false.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Always returns false.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"returnNull"},children:[{type:"desc",attributes:{"text":"<p>Simply return null.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Always returns null.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"returnThis"},children:[{type:"desc",attributes:{"text":"<p>Return &#8220;this&#8221;.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Always returns &#8220;this&#8221;.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"returnTrue"},children:[{type:"desc",attributes:{"text":"<p>Simply return true.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Always returns true.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"returnZero"},children:[{type:"desc",attributes:{"text":"<p>Simply return 0.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Always returns 0.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]}]}]}]}