{type:"class",attributes:{"name":"Composite","packageName":"qx.ui.container","mixins":"qx.ui.core.MChildrenHandling,qx.ui.core.MLayoutHandling","superClass":"qx.ui.core.Widget","childClasses":"qx.ui.container.Resizer,qx.ui.popup.Popup,qx.ui.progressive.Progressive,qx.ui.progressive.headfoot.Abstract,qx.ui.table.headerrenderer.HeaderCell,qx.ui.table.pane.Clipper,qx.ui.table.pane.FocusIndicator,qx.ui.tabview.Page,qx.ui.toolbar.PartContainer","fullName":"qx.ui.container.Composite","type":"class"},children:[{type:"desc",attributes:{"text":"<p>The Composite is a generic container widget.</p>\n\n<p>It exposes all methods to set layouts and to manage child widgets\nas public methods. You must configure this widget with a layout manager to\ndefine the way the widget&#8217;s children are positioned.</p>\n\n<p><strong>Example</strong></p>\n\n<p>Here is a little example of how to use the widget.</p>\n\n<pre class=\"javascript\">\n  // create the composite\n  var composite = new qx.ui.container.Composite()\n\n  // configure it with a horizontal box layout with a spacing of '5'\n  composite.setLayout(new qx.ui.layout.HBox(5));\n\n  // add some children\n  composite.add(new qx.ui.basic.Label(\"Name: \"));\n  composite.add(new qx.ui.form.TextField());\n\n  this.getRoot().add(composite);\n</pre>\n\n<p>This example horizontally groups a label and text field by using a\nComposite configured with a horizontal box layout as a container.</p>\n\n<p><strong>External Documentation</strong></p>\n\n<a href=\"http://qooxdoo.org/documentation/0.8/widget/Composite\" target=\"_blank\">\nDocumentation of this widget in the qooxdoo wiki.</a>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.ui.core.Widget","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"layout"},children:[{type:"desc",attributes:{"text":"<p>A layout instance to use to\n  place widgets on the screen.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.layout.Abstract"}}]}]}]}]}]},{type:"events",children:[{type:"event",attributes:{"name":"addChildWidget"},children:[{type:"desc",attributes:{"text":"<p>This event is fired after a child widget was added to this widget. The\n{@link qx.event.type.Data#getData} method of the event returns the\nadded child.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"removeChildWidget"},children:[{type:"desc",attributes:{"text":"<p>This event is fired after a child widget has been removed from this widget.\nThe {@link qx.event.type.Data#getData} method of the event returns the\nremoved child.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_afterAddChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"}}]}]},{type:"method",attributes:{"access":"protected","docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_afterRemoveChild"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"}}]}]}]}]}