{type:"class",attributes:{"name":"MRemoteChildrenHandling","packageName":"qx.ui.core","includer":"qx.ui.toolbar.Part,qx.ui.form.AbstractSelectBox,qx.ui.form.List,qx.ui.groupbox.GroupBox,qx.ui.container.SlideBar,qx.ui.window.Window","fullName":"qx.ui.core.MRemoteChildrenHandling","type":"mixin"},children:[{type:"desc",attributes:{"text":"<p>This mixin redirects all children handling methods to a child widget of the\nincluding class. This is e.g. used in {@link qx.ui.window.Window} to add\nchild widgets directly to the window pane.</p>\n\n<p>The including class must implement the method <code>getChildrenContainer</code>,\nwhich has to return the widget, to which the child widgets should be added.</p>"}},{type:"methods",children:[{type:"method",attributes:{"isMixin":"true","name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>the item to add.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"options"},children:[{type:"desc",attributes:{"text":"<p>Optional layout data for item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds a new child widget.</p>\n\n<p>The supported keys of the layout options map depend on the layout manager\nused to position the widget. The options are documented in the class\ndocumentation of each layout manager {@link qx.ui.layout}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>This object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Widget"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"addAfter"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>item to add</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]},{type:"param",attributes:{"name":"after"},children:[{type:"desc",attributes:{"text":"<p>item, after which the new item will be inserted</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"options"},children:[{type:"desc",attributes:{"text":"<p>Optional layout data for item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Add a item after another already inserted item</p>\n\n<p>This method works on the widget&#8217;s children list. Some layout managers\n(e.g. {@link qx.ui.layout.HBox}) use the children order as additional\nlayout information. Other layout manager (e.g. {@link qx.ui.layout.Grid})\nignore the children order for the layout process.</p>"}}]},{type:"method",attributes:{"isMixin":"true","name":"addAt"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>item to add</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]},{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>Index, at which the item will be inserted</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"options"},children:[{type:"desc",attributes:{"text":"<p>Optional layout data for item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Add a child at the specified index</p>\n\n<p>This method works on the widget&#8217;s children list. Some layout managers\n(e.g. {@link qx.ui.layout.HBox}) use the children order as additional\nlayout information. Other layout manager (e.g. {@link qx.ui.layout.Grid})\nignore the children order for the layout process.</p>"}}]},{type:"method",attributes:{"isMixin":"true","name":"addBefore"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>item to add</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]},{type:"param",attributes:{"name":"before"},children:[{type:"desc",attributes:{"text":"<p>item before the new item will be inserted.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]},{type:"param",attributes:{"defaultValue":"null","name":"options"},children:[{type:"desc",attributes:{"text":"<p>Optional layout data for item.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Add a item before another already inserted item</p>\n\n<p>This method works on the widget&#8217;s children list. Some layout managers\n(e.g. {@link qx.ui.layout.HBox}) use the children order as additional\nlayout information. Other layout manager (e.g. {@link qx.ui.layout.Grid})\nignore the children order for the layout process.</p>"}}]},{type:"method",attributes:{"isMixin":"true","name":"getChildren"},children:[{type:"desc",attributes:{"text":"<p>Returns the children list</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The children array (Arrays are\n  reference types, please to not modify them in-place)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem","dimensions":"1"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"hasChildren"},children:[{type:"desc",attributes:{"text":"<p>Whether the widget contains children.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Returns <code>true</code> when the widget has children.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"indexOf"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>the item to query for</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the index position of the given item if it is\na child item. Otherwise it returns <code>-1</code>.</p>\n\n<p>This method works on the widget&#8217;s children list. Some layout managers\n(e.g. {@link qx.ui.layout.HBox}) use the children order as additional\nlayout information. Other layout manager (e.g. {@link qx.ui.layout.Grid})\nignore the children order for the layout process.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The index position or <code>-1</code> when\n  the given item is no child of this layout.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"child"},children:[{type:"desc",attributes:{"text":"<p>the item to remove</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"LayoutItem"}}]}]}]},{type:"desc",attributes:{"text":"<p>Remove the given child item.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>This object (for chaining support)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Widget"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"removeAll"},children:[{type:"desc",attributes:{"text":"<p>Remove all children.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"isMixin":"true","name":"removeAt"},children:[{type:"params",children:[{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>Index of the item to remove.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Remove the item at the specified index.</p>\n\n<p>This method works on the widget&#8217;s children list. Some layout managers\n(e.g. {@link qx.ui.layout.HBox}) use the children order as additional\nlayout information. Other layout manager (e.g. {@link qx.ui.layout.Grid})\nignore the children order for the layout process.</p>"}}]}]}]}