{type:"class",attributes:{"name":"DateField","packageName":"qx.ui.form","superClass":"qx.ui.form.ComboBox","fullName":"qx.ui.form.DateField","type":"class"},children:[{type:"desc",attributes:{"text":"<p>A <strong>date field</strong> is like a combo box with the date as popup. As button to\nopen the calendeer a calender icon is shown at the right to the textfield.</p>\n\n<p>To be conform with all form widgets, the {@link qx.ui.form.IFormElement} interface\nis implemented.</p>\n\n<p>The following example creates a date field and sets the current\ndate as selected.</p>\n\n<pre class=\"javascript\">\nvar dateField = new qx.ui.form.DateField();\nthis.getRoot().add(dateField, {top: 20, left: 20});\ndateField.setDate(new Date());\n</pre>"}},{type:"constructor",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.ui.form.ComboBox","isCtor":"true","name":"ctor"}}]},{type:"properties",children:[{type:"property",attributes:{"name":"appearance","docFrom":"qx.ui.core.Widget","defaultValue":"\"datefield\"","refine":"true","propertyType":"new","overriddenFrom":"qx.ui.form.ComboBox"}},{type:"property",attributes:{"check":"qx.util.format.DateFormat","apply":"_applyDateFormat","name":"dateFormat","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The formatter, which converts the selected date to a string. *</p>"}}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.ui.form.DateField#dateFormat","name":"_applyDateFormat"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.util.format.DateFormat"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.util.format.DateFormat"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>dateFormat</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applyDateFormat}.</p>"}}]},{type:"method",attributes:{"access":"protected","docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.form.ComboBox","name":"_createChildControlImpl"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"}}]}]},{type:"method",attributes:{"access":"protected","name":"_onChangeDate"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>The mouse event of the click.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handler method which handles the click on the calender popup.</p>"}}]},{type:"method",attributes:{"access":"protected","overriddenFrom":"qx.ui.form.ComboBox","name":"_onKeyPress"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Keypress event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeyEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handler method which hadles the key press. It forwards all key event\nto the opened date chooser except the escape key event. Escape closes\nthe popup.\nIf the list is clodes, all key events will not be processed further.</p>"}}]},{type:"method",attributes:{"access":"protected","docFrom":"qx.ui.form.AbstractSelectBox","overriddenFrom":"qx.ui.form.ComboBox","name":"_onPopupChangeVisibility"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"}}]}]},{type:"method",attributes:{"access":"protected","overriddenFrom":"qx.ui.form.ComboBox","name":"_onTextFieldChangeValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Change event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]},{type:"desc",attributes:{"text":"<p>Reacts on value changes of the text field and syncs the\nvalue to the combobox.</p>"}}]},{type:"method",attributes:{"name":"getDate"},children:[{type:"desc",attributes:{"text":"<p>Returns the current set date corresponding to the {@link dateFormat}.\nIf the given text could not be parsed, <code>null</code> will be returned.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The currently set date.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Date"}}]}]}]},{type:"method",attributes:{"name":"getDateFormat","fromProperty":"dateFormat"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>dateFormat</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #dateFormat}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>dateFormat</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.ui.form.ComboBox","name":"getValue"},children:[{type:"desc",attributes:{"text":"<p>Returns the value in the textfield.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The string value of the textfield.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initDateFormat","fromProperty":"dateFormat"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>dateFormat</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>dateFormat</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #dateFormat}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"resetDateFormat","fromProperty":"dateFormat"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>dateFormat</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #dateFormat}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setDate"},children:[{type:"params",children:[{type:"param",attributes:{"name":"date"},children:[{type:"desc",attributes:{"text":"<p>The date to set.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Date"}}]}]}]},{type:"desc",attributes:{"text":"<p>This method sets the date corresponding to the {@link dateFormat} to the\ndate field. It will also select the date in the calender popup.</p>"}}]},{type:"method",attributes:{"name":"setDateFormat","fromProperty":"dateFormat"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>dateFormat</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>dateFormat</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #dateFormat}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.ui.form.ComboBox","name":"setValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>The String value to set.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the given value to the textfield. If the value could be\na date corresponding to the set {@link dateFormat}, the date is\nselected in the calender popup.</p>"}}]}]}]}