{type:"class",attributes:{"name":"Dock","packageName":"qx.ui.layout","superClass":"qx.ui.layout.Abstract","fullName":"qx.ui.layout.Dock","type":"class"},children:[{type:"desc",attributes:{"text":"<p>Docks children to one of the edges.</p>\n\n<p><strong>Features</strong></p>\n\n<ul>\n<li>Percent width for left/right/center attached children</li>\n<li>Percent height for top/bottom/center attached children</li>\n<li>Minimum and maximum dimensions</li>\n<li>Prioritized growing/shrinking (flex)</li>\n<li>Auto sizing</li>\n<li>Margins and Spacings</li>\n<li>Alignment in orthogonal axis (e.g. alignX of north attached)</li>\n<li>Different sort options for children</li>\n</ul>\n\n<p><strong>Item Properties</strong></p>\n\n<ul>\n<li><strong>edge</strong> <em>(String)</em>: The edge where the layout item\n  should be docked. This may be one of <code>north</code>, <code>east</code>,\n  <code>south</code>, <code>west</code> or <code>center</code>. (Required)</li>\n<li><strong>width</strong> <em>(String)</em>: Defines a percent\n  width for the item. The percent width,\n  when specified, is used instead of the width defined by the size hint.\n  This is only supported for children added to the north or south edge or\n  are centered in the middle of the layout.\n  The minimum and maximum width still takes care of the elements limitations.\n  It has no influence on the layout's size hint. Percents are mainly useful for\n  widgets which are sized by the outer hierarchy.\n</li>\n<li><strong>height</strong> <em>(String)</em>: Defines a percent\n  height for the item. The percent height,\n  when specified, is used instead of the height defined by the size hint.\n  This is only supported for children added to the west or east edge or\n  are centered in the middle of the layout.\n  The minimum and maximum height still takes care of the elements limitations.\n  It has no influence on the layout's size hint. Percents are mainly useful for\n  widgets which are sized by the outer hierarchy.\n</li>\n</ul>\n\n<p><strong>Example</strong></p>\n\n<pre class=\"javascript\">\nvar layout = new qx.ui.layout.Dock();\n\nvar w1 = new qx.ui.core.Widget();\nvar w2 = new qx.ui.core.Widget();\nvar w3 = new qx.ui.core.Widget();\n\nw1.setHeight(200);\nw2.setWidth(150);\n\nvar container = new qx.ui.container.Composite(layout);\ncontainer.add(w1, {edge:\"north\"});\ncontainer.add(w2, {edge:\"west\"});\ncontainer.add(w3, {edge:\"center\"});\n</pre>\n\n<p><strong>Detailed Description</strong></p>\n\n<p>Using this layout, items may be &#8220;docked&#8221; to a specific side\nof the available space. Each displayed item reduces the available space\nfor the following children. Priorities depend on the position of\nthe child in the internal children list.</p>\n\n<p><strong>External Documentation</strong></p>\n\n<a href=\"http://qooxdoo.org/documentation/0.8/layout/Dock\">\nExtended documentation</a> and links to demos of this layout in the qooxdoo wiki."}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.core.Object","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"0","name":"spacingX"},children:[{type:"desc",attributes:{"text":"<p>The horizontal spacing. Sets {@link #spacingX}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"defaultValue":"0","name":"spacingY"},children:[{type:"desc",attributes:{"text":"<p>The vertical spacing. Sets {@link #spacingY}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"separatorX"},children:[{type:"desc",attributes:{"text":"<p>Separator to render between columns</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Decorator"}}]}]},{type:"param",attributes:{"name":"separatorY"},children:[{type:"desc",attributes:{"text":"<p>Separator to render between rows</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Decorator"}}]}]}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"private","name":"__rebuildCache"},children:[{type:"desc",attributes:{"text":"<p>Rebuilds cache for sorted children list.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.layout.Dock#sort","name":"_applySort"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>sort</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applySort}.</p>"}}]},{type:"method",attributes:{"access":"protected","docFrom":"qx.ui.layout.Abstract","overriddenFrom":"qx.ui.layout.Abstract","name":"_computeSizeHint"}},{type:"method",attributes:{"access":"protected","name":"_getSeparatorWidths"},children:[{type:"desc",attributes:{"text":"<p>Computes the dimensions each separater on both the <code>x</code> and\n<code>y</code> axis needs.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Map with the keys <code>x</code> and\n  <code>y</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"name":"getConnectSeparators","fromProperty":"connectSeparators"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>connectSeparators</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #connectSeparators}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>connectSeparators</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getSeparatorX","fromProperty":"separatorX"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>separatorX</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #separatorX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>separatorX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getSeparatorY","fromProperty":"separatorY"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>separatorY</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #separatorY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>separatorY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getSort","fromProperty":"sort"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>sort</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #sort}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>sort</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getSpacingX","fromProperty":"spacingX"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>spacingX</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #spacingX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>spacingX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getSpacingY","fromProperty":"spacingY"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>spacingY</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #spacingY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>spacingY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initConnectSeparators","fromProperty":"connectSeparators"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>connectSeparators</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>connectSeparators</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #connectSeparators}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initSeparatorX","fromProperty":"separatorX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>separatorX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>separatorX</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #separatorX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initSeparatorY","fromProperty":"separatorY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>separatorY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>separatorY</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #separatorY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initSort","fromProperty":"sort"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>sort</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>sort</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #sort}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initSpacingX","fromProperty":"spacingX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>spacingX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>spacingX</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #spacingX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initSpacingY","fromProperty":"spacingY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>spacingY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>spacingY</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #spacingY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"isConnectSeparators","fromProperty":"connectSeparators"},children:[{type:"desc",attributes:{"text":"<p>Check whether the (computed) value of the boolean property <code>connectSeparators</code> equals <code>true</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #connectSeparators}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the property equals <code>true</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.ui.layout.Abstract","overriddenFrom":"qx.ui.layout.Abstract","name":"renderLayout"},children:[{type:"params",children:[{type:"param",attributes:{"name":"availWidth"}},{type:"param",attributes:{"name":"availHeight"}}]}]},{type:"method",attributes:{"name":"resetConnectSeparators","fromProperty":"connectSeparators"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>connectSeparators</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #connectSeparators}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetSeparatorX","fromProperty":"separatorX"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>separatorX</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #separatorX}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetSeparatorY","fromProperty":"separatorY"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>separatorY</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #separatorY}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetSort","fromProperty":"sort"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>sort</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #sort}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetSpacingX","fromProperty":"spacingX"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>spacingX</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #spacingX}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetSpacingY","fromProperty":"spacingY"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>spacingY</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #spacingY}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setConnectSeparators","fromProperty":"connectSeparators"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>connectSeparators</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>connectSeparators</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #connectSeparators}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setSeparatorX","fromProperty":"separatorX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>separatorX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>separatorX</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #separatorX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setSeparatorY","fromProperty":"separatorY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>separatorY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>separatorY</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #separatorY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setSort","fromProperty":"sort"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>sort</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>sort</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #sort}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setSpacingX","fromProperty":"spacingX"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>spacingX</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>spacingX</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #spacingX}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setSpacingY","fromProperty":"spacingY"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>spacingY</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>spacingY</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #spacingY}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"toggleConnectSeparators","fromProperty":"connectSeparators"},children:[{type:"desc",attributes:{"text":"<p>Toggles the (computed) value of the boolean property <code>connectSeparators</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #connectSeparators}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the new value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"check":"Boolean","apply":"_applyLayoutChange","defaultValue":"false","name":"connectSeparators","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Whether separators should be collapsed so when a spacing is\nconfigured the line go over into each other</p>"}}]},{type:"property",attributes:{"allowNull":"true","apply":"_applyLayoutChange","check":"Decorator","name":"separatorX","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Separator lines to use between the horizontal objects</p>"}}]},{type:"property",attributes:{"allowNull":"true","apply":"_applyLayoutChange","check":"Decorator","name":"separatorY","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Separator lines to use between the vertical objects</p>"}}]},{type:"property",attributes:{"apply":"_applySort","defaultValue":"\"auto\"","name":"sort","possibleValues":"\"auto\",\"y\",\"x\"","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The way the widgets should be displayed (in conjunction with their\nposition in the childrens array).</p>"}}]},{type:"property",attributes:{"check":"Integer","apply":"_applyLayoutChange","defaultValue":"0","name":"spacingX","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Horizontal spacing between two children</p>"}}]},{type:"property",attributes:{"check":"Integer","apply":"_applyLayoutChange","defaultValue":"0","name":"spacingY","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Vertical spacing between two children</p>"}}]}]}]}