{type:"class",attributes:{"isStatic":"true","name":"Util","isInternal":"true","packageName":"qx.ui.layout","access":"internal","fullName":"qx.ui.layout.Util","type":"class"},children:[{type:"desc",attributes:{"text":"<p>Common set of utility methods used by the standard qooxdoo layouts.</p>"}},{type:"methods-static",children:[{type:"method",attributes:{"isStatic":"true","name":"arrangeIdeals"},children:[{type:"params",children:[{type:"param",attributes:{"name":"beginMin"},children:[{type:"desc",attributes:{"text":"<p>Minimum size of first widget (from size hint)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"beginIdeal"},children:[{type:"desc",attributes:{"text":"<p>Ideal size of first widget (maybe after dragging the splitter)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"beginMax"},children:[{type:"desc",attributes:{"text":"<p>Maximum size of first widget (from size hint)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"endMin"},children:[{type:"desc",attributes:{"text":"<p>Minimum size of second widget (from size hint)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"endIdeal"},children:[{type:"desc",attributes:{"text":"<p>Ideal size of second widget (maybe after dragging the splitter)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"endMax"},children:[{type:"desc",attributes:{"text":"<p>Maximum size of second widget (from size hint)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Arranges two sizes in one box to best respect their individual limitations.</p>\n\n<p>Mainly used by split layouts (Split Panes) where the layout is mainly defined\nby the outer dimensions.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Map with the keys <code>begin<code>end</code> with the\n  arranged dimensions.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"collapseMargins"},children:[{type:"params",children:[{type:"param",attributes:{"name":"varargs"},children:[{type:"desc",attributes:{"text":"<p>Any number of configured margins</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"arguments"}}]}]}]},{type:"desc",attributes:{"text":"<p>Collapses two margins.</p>\n\n<p>Supports positive and negative margins.\nCollapsing find the largest positive and the largest\nnegative value. Afterwards the result is computed through the\nsubstraction of the negative from the positive value.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The collapsed margin</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"computeFlexOffsets"},children:[{type:"params",children:[{type:"param",attributes:{"name":"flexibles"},children:[{type:"desc",attributes:{"text":"<p>{Map[]) Each entry must have these keys:\n  <code>id</code>, <code>potential</code> and <code>flex</code>.\n  The ID is used in the result map as the key for the user to work\n  with later (e.g. upgrade sizes etc. to respect the given offset)\n  The potential is an integer value which is the difference of the\n  currently interesting direction (e.g. shrinking=width-minWidth, growing=\n  maxWidth-width). The flex key holds the flex value of the item.</p>"}}]},{type:"param",attributes:{"name":"avail"},children:[{type:"desc",attributes:{"text":"<p>Full available space to allocate (ignoring used one)</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"used"},children:[{type:"desc",attributes:{"text":"<p>Size of already allocated space</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Computes the flex offsets needed to reduce the space\ndifference as much as possible by respecting the\npotential of the given elements (being in the range of\ntheir min/max values)</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A map which contains the calculated offsets under the key\n  which is identical to the ID given in the incoming map.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"computeHorizontalAlignOffset"},children:[{type:"params",children:[{type:"param",attributes:{"name":"align"},children:[{type:"desc",attributes:{"text":"<p>One of <code>top</code>, <code>center</code> or <code>bottom</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"width"},children:[{type:"desc",attributes:{"text":"<p>The visible width of the widget</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"availWidth"},children:[{type:"desc",attributes:{"text":"<p>The available inner width of the parent</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"defaultValue":"0","name":"marginLeft"},children:[{type:"desc",attributes:{"text":"<p>Optional left margin of the widget</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"defaultValue":"0","name":"marginRight"},children:[{type:"desc",attributes:{"text":"<p>Optional right margin of the widget</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Computes the offset which needs to be added to the top position\nto result in the stated vertical alignment. Also respects\nexisting margins (without collapsing).</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Computed top coordinate</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"computeHorizontalGaps"},children:[{type:"params",children:[{type:"param",attributes:{"name":"children"},children:[{type:"desc",attributes:{"text":"<p>List of children</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]},{type:"param",attributes:{"defaultValue":"0","name":"spacing"},children:[{type:"desc",attributes:{"text":"<p>Spacing between every child</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"collapse"},children:[{type:"desc",attributes:{"text":"<p>Optional margin collapsing mode</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Computes the sum of all horizontal gaps. Normally the\nresult is used to compute the available width in a widget.</p>\n\n<p>The method optionally respects margin collapsing as well. In\nthis mode the spacing is collapsed together with the margins.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Sum of all gaps in the final layout.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"computeHorizontalSeparatorGaps"},children:[{type:"params",children:[{type:"param",attributes:{"name":"children"},children:[{type:"desc",attributes:{"text":"<p>List of children</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.LayoutItem","dimensions":"1"}}]}]},{type:"param",attributes:{"name":"spacing"},children:[{type:"desc",attributes:{"text":"<p>Configured spacing</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"separator"},children:[{type:"desc",attributes:{"text":"<p>Separator to render</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Separator"}}]}]}]},{type:"desc",attributes:{"text":"<p>Computes the gaps together with the configuration of separators.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Sum of gaps</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"computeVerticalAlignOffset"},children:[{type:"params",children:[{type:"param",attributes:{"name":"align"},children:[{type:"desc",attributes:{"text":"<p>One of <code>top</code>, <code>middle</code> or <code>bottom</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"height"},children:[{type:"desc",attributes:{"text":"<p>The visible height of the widget</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"availHeight"},children:[{type:"desc",attributes:{"text":"<p>The available inner height of the parent</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"defaultValue":"0","name":"marginTop"},children:[{type:"desc",attributes:{"text":"<p>Optional top margin of the widget</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"defaultValue":"0","name":"marginBottom"},children:[{type:"desc",attributes:{"text":"<p>Optional bottom margin of the widget</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Computes the offset which needs to be added to the top position\nto result in the stated vertical alignment. Also respects\nexisting margins (without collapsing).</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Computed top coordinate</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"computeVerticalGaps"},children:[{type:"params",children:[{type:"param",attributes:{"name":"children"},children:[{type:"desc",attributes:{"text":"<p>List of children</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]},{type:"param",attributes:{"defaultValue":"0","name":"spacing"},children:[{type:"desc",attributes:{"text":"<p>Spacing between every child</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"defaultValue":"false","name":"collapse"},children:[{type:"desc",attributes:{"text":"<p>Optional margin collapsing mode</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Computes the sum of all vertical gaps. Normally the\nresult is used to compute the available height in a widget.</p>\n\n<p>The method optionally respects margin collapsing as well. In\nthis mode the spacing is collapsed together with the margins.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Sum of all gaps in the final layout.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"computeVerticalSeparatorGaps"},children:[{type:"params",children:[{type:"param",attributes:{"name":"children"},children:[{type:"desc",attributes:{"text":"<p>List of children</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.LayoutItem","dimensions":"1"}}]}]},{type:"param",attributes:{"name":"spacing"},children:[{type:"desc",attributes:{"text":"<p>Configured spacing</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"separator"},children:[{type:"desc",attributes:{"text":"<p>Separator to render</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Separator"}}]}]}]},{type:"desc",attributes:{"text":"<p>Computes the gaps together with the configuration of separators.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Sum of gaps</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"type":"Regexp","name":"PERCENT_VALUE","value":"/[0-9]+(?:\.[0-9]+)?%/"},children:[{type:"desc",attributes:{"text":"<p>Regular expression to match percent values</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Regexp"}}]}]}]}]}