{type:"class",attributes:{"name":"Pane","packageName":"qx.ui.splitpane","superClass":"qx.ui.core.Widget","fullName":"qx.ui.splitpane.Pane","type":"class"},children:[{type:"desc",attributes:{"text":"<p>A split panes divides a area into two panes. The ratio between the two\npanes is configurable by the user using the splitter.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.ui.core.Widget","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"orientation"},children:[{type:"desc",attributes:{"text":"<p>The orientation of the split pane control.\nAllowed values are &#8220;horizontal&#8221; (default) and &#8220;vertical&#8221;.\nThis is the same type as used in {@link qx.ui.layout.HBox#orientation}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates a new instance of a SplitPane. It allows the user to dynamically\nresize the areas dropping the border between.</p>"}}]}]},{type:"properties",children:[{type:"property",attributes:{"name":"appearance","docFrom":"qx.ui.core.Widget","defaultValue":"\"splitpane\"","refine":"true","propertyType":"new","overriddenFrom":"qx.ui.core.Widget"}},{type:"property",attributes:{"apply":"_applyOrientation","defaultValue":"\"horizontal\"","name":"orientation","possibleValues":"\"horizontal\",\"vertical\"","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>The orientation of the splitpane control.</p>"}}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"private","name":"__computeSizes"},children:[{type:"desc",attributes:{"text":"<p>Computes widgets&#8217; sizes based on the mouse coordinate</p>"}}]},{type:"method",attributes:{"access":"private","name":"__finalizeSizes"},children:[{type:"desc",attributes:{"text":"<p>Updates widgets&#8217; sizes bases on slider position.</p>"}}]},{type:"method",attributes:{"access":"private","name":"__isNear"},children:[{type:"desc",attributes:{"text":"<p>Checks if mouse cursor is on or near the splitter widget.\nThis method will be used for horizontal orientation.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>True if mouse cursor is near to splitter, otherwise false.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__updateCursor"},children:[{type:"desc",attributes:{"text":"<p>Updates the pane&#8217;s cursor based on the mouse position</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.splitpane.Pane#orientation","name":"_applyOrientation"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>The new value of the orientation property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>The old value of the orientation property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Apply routine for the orientation property.</p>\n\n<p>Sets the pane&#8217;s layout to vertical or horizontal split layout.</p>"}}]},{type:"method",attributes:{"access":"protected","docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_createChildControlImpl"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"}}]}]},{type:"method",attributes:{"access":"protected","name":"_onMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>mouseDown event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handler for mousedown event.</p>\n\n<p>Shows slider widget and starts drag session if mouse is near/on splitter widget.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onMouseMove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>mouseMove event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handler for mousemove event.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onMouseOut"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>mouseout event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handler for mouseout event</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onMouseUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>mouseup event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.MouseEvent"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handler for mouseup event</p>\n\n<p>Sets widget sizes if dragging session has been active.</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onSplitterMove"},children:[{type:"desc",attributes:{"text":"<p>Handler for move event of splitter</p>"}}]},{type:"method",attributes:{"name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"widget"},children:[{type:"desc",attributes:{"text":"<p>The widget to be inserted into pane.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]},{type:"param",attributes:{"name":"flex"},children:[{type:"desc",attributes:{"text":"<p>The (optional) layout property for the widget&#8217;s flex value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds a widget to the pane.</p>\n\n<p>Sets the pane&#8217;s layout to vertical or horizontal split layout. Depending on the\npane&#8217;s layout the first widget will be the left or top widget, the second one\nthe bottom or left widget. Adding more than two widgets will overwrite the\nexisting ones.</p>"}}]},{type:"method",attributes:{"name":"getOrientation","fromProperty":"orientation"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>orientation</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #orientation}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>orientation</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initOrientation","fromProperty":"orientation"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>orientation</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>orientation</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #orientation}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"widget"},children:[{type:"desc",attributes:{"text":"<p>The widget to be removed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes the given widget from the pane.</p>"}}]},{type:"method",attributes:{"name":"resetOrientation","fromProperty":"orientation"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>orientation</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #orientation}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setOrientation","fromProperty":"orientation"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>orientation</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>orientation</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #orientation}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]}]}]}