{type:"class",attributes:{"name":"Dynamic","packageName":"qx.ui.table.celleditor","superClass":"qx.core.Object","fullName":"qx.ui.table.celleditor.Dynamic","type":"class","interfaces":"qx.ui.table.ICellEditorFactory"},children:[{type:"desc",attributes:{"text":"<p>A cell editor factory which can dynamically exchange the cell editor\nbased on information retrieved at runtime. This is useful when different\nrows in a column should have different cellEditors based on cell content\nor row meta data. A typical example would be a spreadsheet that has different\nkind of data in one column.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.core.Object","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"defaultValue":"null","name":"cellEditorFactoryFunction"},children:[{type:"desc",attributes:{"text":"<p>the factory function\n   {@link #cellEditorFactoryFunction}.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]}]}]},{type:"methods",children:[{type:"method",attributes:{"name":"createCellEditor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellInfo"},children:[{type:"desc",attributes:{"text":"<p>A map containing the information about the cell to\n     create.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Creates the cell editor based on the cellEditorFactory instance\nreturned by the function stored in the cellEditorFactoryFunction\nproperty. Passes the cellInfo map to the function.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"name":"getCellEditorFactoryFunction","fromProperty":"cellEditorFactoryFunction"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>cellEditorFactoryFunction</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #cellEditorFactoryFunction}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>cellEditorFactoryFunction</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.ui.table.ICellEditorFactory","name":"getCellEditorValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"cellEditor"}}]}]},{type:"method",attributes:{"access":"protected","name":"initCellEditorFactoryFunction","fromProperty":"cellEditorFactoryFunction"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>cellEditorFactoryFunction</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>cellEditorFactoryFunction</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #cellEditorFactoryFunction}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"resetCellEditorFactoryFunction","fromProperty":"cellEditorFactoryFunction"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>cellEditorFactoryFunction</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #cellEditorFactoryFunction}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setCellEditorFactoryFunction","fromProperty":"cellEditorFactoryFunction"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>cellEditorFactoryFunction</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>cellEditorFactoryFunction</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #cellEditorFactoryFunction}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"check":"Function","allowNull":"true","defaultValue":"null","name":"cellEditorFactoryFunction","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Function that returns a cellEditorFactory instance which will be\nused for the row that is currently being edited. The function is\ndefined like this:</p>\n\n<pre class=\"javascript\">\nmyTable.getTableColumnModel().setCellEditorFactory(function(cellInfo){\n  // based on the cellInfo map or other information, return the\n  // appropriate cellEditorFactory\n  if (cellInfo.row == 5)\n    return new qx.ui.table.celleditor.CheckBox;\n  else\n    return new qx.ui.table.celleditor.TextField;\n});\n</pre>"}}]}]}]}