{type:"class",attributes:{"name":"TabView","packageName":"qx.ui.tabview","mixins":"qx.ui.core.MContentPadding","superClass":"qx.ui.core.Widget","fullName":"qx.ui.tabview.TabView","type":"class"},children:[{type:"desc",attributes:{"text":"<p>A tab view is a multi page view where only one page is visible\nat each moment. It is possible to switch the pages using the\nbuttons rendered by each page.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.ui.core.Widget","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"barPosition"},children:[{type:"desc",attributes:{"text":"<p>Initial bar position ({@link #barPosition})</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]}]}]},{type:"events",children:[{type:"event",attributes:{"name":"changeSelected"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #selected}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.ui.tabview.TabView#barPosition","name":"_applyBarPosition"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>The new value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>The old value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"boolean"}}]}]}]},{type:"desc",attributes:{"text":"<p>Apply method for the placeBarOnTop-Property.</p>\n\n<p>Passes the desired value to the layout of the tabview so\nthat the layout can handle it.\nIt also sets the states to all buttons so they know the\nposition of the bar.</p>"}}]},{type:"method",attributes:{"access":"protected","apply":"qx.ui.tabview.TabView#selected","name":"_applySelected"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.tabview.Page"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.tabview.Page"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>selected</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applySelected}.</p>"}}]},{type:"method",attributes:{"access":"protected","docFrom":"qx.ui.core.Widget","overriddenFrom":"qx.ui.core.Widget","name":"_createChildControlImpl"},children:[{type:"params",children:[{type:"param",attributes:{"name":"id"}}]}]},{type:"method",attributes:{"access":"protected","name":"_getContentPaddingTarget"},children:[{type:"desc",attributes:{"text":"<p>Returns the element, to which the content padding should be applied.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The content padding target.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Widget"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"_onRadioChangeValue"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>The data event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event handler for the change of the selected item of the radio group.</p>"}}]},{type:"method",attributes:{"name":"add"},children:[{type:"params",children:[{type:"param",attributes:{"name":"page"},children:[{type:"desc",attributes:{"text":"<p>The page which should be added.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.tabview.Page"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds a page to the tabview including its needed button\n(contained in the page).</p>"}}]},{type:"method",attributes:{"name":"getBarPosition","fromProperty":"barPosition"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>barPosition</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #barPosition}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>barPosition</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getChildren"},children:[{type:"desc",attributes:{"text":"<p>Returns TabView&#8217;s children widgets.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>List of children.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]}]},{type:"method",attributes:{"name":"getSelected","fromProperty":"selected"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>selected</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #selected}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>selected</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"indexOf"},children:[{type:"params",children:[{type:"param",attributes:{"name":"page"},children:[{type:"desc",attributes:{"text":"<p>The page to query for</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.tabview.Page"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the positon of the given page in the TabView</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Position of the page in the TabView</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initBarPosition","fromProperty":"barPosition"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>barPosition</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>barPosition</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #barPosition}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initSelected","fromProperty":"selected"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>selected</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>selected</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #selected}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"remove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"page"},children:[{type:"desc",attributes:{"text":"<p>The page to be removed.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.tabview.Page"}}]}]}]},{type:"desc",attributes:{"text":"<p>Removes a page (and its corresponding button) from the TabView.</p>"}}]},{type:"method",attributes:{"name":"resetBarPosition","fromProperty":"barPosition"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>barPosition</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #barPosition}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetSelected","fromProperty":"selected"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>selected</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #selected}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setBarPosition","fromProperty":"barPosition"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>barPosition</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>barPosition</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #barPosition}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setSelected","fromProperty":"selected"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>selected</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>selected</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #selected}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"name":"appearance","docFrom":"qx.ui.core.Widget","defaultValue":"\"tabview\"","refine":"true","propertyType":"new","overriddenFrom":"qx.ui.core.Widget"}},{type:"property",attributes:{"apply":"_applyBarPosition","defaultValue":"\"top\"","name":"barPosition","possibleValues":"\"left\",\"right\",\"top\",\"bottom\"","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>This property defines on which side of the TabView the bar should be positioned.</p>"}}]},{type:"property",attributes:{"name":"selected","check":"qx.ui.tabview.Page","allowNull":"true","propertyType":"new","apply":"_applySelected","event":"changeSelected"},children:[{type:"desc",attributes:{"text":"<p>The selected page inside the TabView.</p>"}}]}]}]}