{type:"class",attributes:{"name":"ToolBar","packageName":"qx.ui.toolbar","mixins":"qx.ui.core.MChildrenHandling","superClass":"qx.ui.core.Widget","childClasses":"qx.ui.menubar.MenuBar","fullName":"qx.ui.toolbar.ToolBar","type":"class"},children:[{type:"desc",attributes:{"text":"<p>The Toolbar class is the main part of the toolbar widget.</p>\n\n<p>It can handle added {@link Button}s, {@link CheckBox}es, {@link RadioButton}s\nand {@link Separator}s in its {@link #add} method. The {@link #addSpacer} method\nadds a spacer at the current toolbar position. This means that the widgets\nadded after the method call of {@link #addSpacer} are aligned to the right of\nthe toolbar.</p>\n\n<p>For more details on the documentation of the toolbar widget, take a look at the\ndocumentation of the {@link qx.ui.toolbar}-Package.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"docFrom":"qx.core.Object","overriddenFrom":"qx.ui.core.Widget","isCtor":"true","name":"ctor"}}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","apply":"qx.ui.toolbar.ToolBar#spacing","name":"_applySpacing"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>new value of the property</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"old"},children:[{type:"desc",attributes:{"text":"<p>previous value of the property (null if it was not yet set).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Applies changes of the property value of the property <code>spacing</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #_applySpacing}.</p>"}}]},{type:"method",attributes:{"name":"addSeparator"},children:[{type:"desc",attributes:{"text":"<p>Adds a separator to the toolbar.</p>"}}]},{type:"method",attributes:{"name":"addSpacer"},children:[{type:"desc",attributes:{"text":"<p>Add a spacer to the toolbar. The spacer has a flex\nvalue of one and will stretch to the available space.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The newly added spacer object. A reference\n  to the spacer is needed to remove ths spacer from the layout.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.core.Spacer"}}]}]}]},{type:"method",attributes:{"name":"getMenuButtons"},children:[{type:"desc",attributes:{"text":"<p>Returns all nested buttons which contains a menu to show. This is mainly\nused for keyboard support.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>List of all menu buttons</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]}]},{type:"method",attributes:{"name":"getOpenMenu","fromProperty":"openMenu"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>openMenu</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #openMenu}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>openMenu</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getShow","fromProperty":"show"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>show</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #show}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>show</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"getSpacing","fromProperty":"spacing"},children:[{type:"desc",attributes:{"text":"<p>Returns the (computed) value of the property <code>spacing</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #spacing}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>(Computed) value of <code>spacing</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initOpenMenu","fromProperty":"openMenu"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>openMenu</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>openMenu</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #openMenu}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initShow","fromProperty":"show"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>show</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>show</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #show}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"access":"protected","name":"initSpacing","fromProperty":"spacing"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>Initial value for property <code>spacing</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Calls the apply method and dispatches the change event of the property <code>spacing</code>\nwith the default value defined by the class developer. This function can\nonly be called from the constructor of a class.</p>\n\n<p>For further details take a look at the property definition: {@link #spacing}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>the default value</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"resetOpenMenu","fromProperty":"openMenu"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>openMenu</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #openMenu}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetShow","fromProperty":"show"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>show</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #show}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"resetSpacing","fromProperty":"spacing"},children:[{type:"desc",attributes:{"text":"<p>Resets the user value of the property <code>spacing</code>.</p>\n\n<p>The computed value falls back to the next available value e.g. appearance, init or\ninheritance value depeneding on the property configuration and value availability.</p>\n\n<p>For further details take a look at the property definition: {@link #spacing}.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"setOpenMenu","fromProperty":"openMenu"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>openMenu</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>openMenu</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #openMenu}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setShow","fromProperty":"show"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>show</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>show</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #show}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"name":"setSpacing","fromProperty":"spacing"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>New value for property <code>spacing</code>.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Sets the user value of the property <code>spacing</code>.</p>\n\n<p>For further details take a look at the property definition: {@link #spacing}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The unmodified incoming value.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]}]},{type:"properties",children:[{type:"property",attributes:{"refine":"true","defaultValue":"\"toolbar\"","overriddenFrom":"qx.ui.core.Widget","name":"appearance","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Appearance of the widget</p>"}}]},{type:"property",attributes:{"event":"changeOpenMenu","allowNull":"true","check":"qx.ui.menu.Menu","name":"openMenu","propertyType":"new"},children:[{type:"desc",attributes:{"text":"<p>Holds the currently open menu (when the toolbar is used for menus)</p>"}}]},{type:"property",attributes:{"name":"show","defaultValue":"\"both\"","inheritable":"true","propertyType":"new","possibleValues":"\"both\",\"label\",\"icon\"","event":"changeShow"},children:[{type:"desc",attributes:{"text":"<p>Whether icons, labels, both or none should be shown.</p>"}}]},{type:"property",attributes:{"name":"spacing","allowNull":"true","propertyType":"new","apply":"_applySpacing","check":"Integer","themeable":"true"},children:[{type:"desc",attributes:{"text":"<p>The spacing between every child of the toolbar</p>"}}]}]},{type:"events",children:[{type:"event",attributes:{"name":"changeOpenMenu"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #openMenu}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]},{type:"event",attributes:{"name":"changeShow"},children:[{type:"desc",attributes:{"text":"Fired on change of the property {@link #show}."}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Data"}}]}]}]}]}