{type:"class",attributes:{"name":"SelectionManager","packageName":"qx.ui.treevirtual","superClass":"qx.ui.table.selection.Manager","fullName":"qx.ui.treevirtual.SelectionManager","type":"class"},children:[{type:"desc",attributes:{"text":"<p>A selection manager. This is a helper class that handles all selection\nrelated events and updates a SelectionModel.</p>\n\n<p>This Selection Manager differs from its superclass in that we do not want\nrows to be selected when moving around with the keyboard.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.ui.table.selection.Manager","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"table"},children:[{type:"desc",attributes:{"text":"<p>The table whose selections are being managed</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.table.Table"}}]}]}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"protected","name":"_handleExtendedClick"},children:[{type:"params",children:[{type:"param",attributes:{"name":"tree"},children:[{type:"desc",attributes:{"text":"<p>The tree on which the event has occurred.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.treevirtual.TreeVirtual"}}]}]},{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>The mouse event.  Of particular interest is evt.getViewportLeft()\n  which is the horizontal offset from the left border of the click.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"node"},children:[{type:"desc",attributes:{"text":"<p>The node which the tree row is displaying</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]},{type:"param",attributes:{"name":"left"},children:[{type:"desc",attributes:{"text":"<p>The offset from the left, of the beginning of the tree column.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handle a mouse click event that is not normally handled by the simple\ntree.  This is intended for more sophisticated trees where clicks in\ndifferent places, e.g. on various icons or on the label itself, should\nbe handled specially.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<i>true</i> if the row should be prevented from being selected;\n  <i>false</i> otherwise."}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"access":"protected","overriddenFrom":"qx.ui.table.selection.Manager","name":"_handleSelectEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>the index the event is pointing at.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the mouse event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handles a select event.  First we determine if the click was on the\nopen/close button and toggle the opened/closed state as necessary.  \nThen, if the click was not on the open/close button or if the table&#8217;s\n&#8220;openCloseClickSelectsRow&#8221; property so indicates, call our superclass to\nhandle the actual row selection.</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]},{type:"method",attributes:{"name":"getTable"},children:[{type:"desc",attributes:{"text":"<p>Getter for the table being managed</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Table being managed</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.ui.table.Table"}}]}]}]},{type:"method",attributes:{"overriddenFrom":"qx.ui.table.selection.Manager","name":"handleMoveKeyDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"index"},children:[{type:"desc",attributes:{"text":"<p>the index that is currently focused.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"param",attributes:{"name":"evt"},children:[{type:"desc",attributes:{"text":"<p>the key event.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"desc",attributes:{"text":"<p>Handles a key down event that moved the focus (E.g. up, down, home,\n end, ...).</p>"}},{type:"return",children:[{type:"types",children:[{type:"entry",attributes:{"type":"void"}}]}]}]}]}]}