{type:"class",attributes:{"isStatic":"true","name":"Validate","packageName":"qx.util","fullName":"qx.util.Validate","type":"class"},children:[{type:"desc",attributes:{"text":"<p><span class=\"caps\">EXPERIMENTAL</span> &#8211; <span class=\"caps\">NOT</span> <span class=\"caps\">READY</span> <span class=\"caps\">FOR</span> <span class=\"caps\">PRODUCTION</span></p>\n\n<p>This static class contains a set of default validators. \nThese validators are listed twice\n<ul>\n  <li>number</li>\n  <li>email</li>\n  <li>string</li>\n  <li>url</li>\n  <li>color</li>\n</ul>\nAll these validators don&#8217;t need an input so the listed function just return a \nmethod fitting for the use in the property system.\nThe methods with the check prefix are the returned methods and can be used in\nother contexts without the property system.</p>\n\n<p>There are three more validators\n<ul>\n  <li>range</li>\n  <li>inArray</li>\n  <li>regExp</li>\n</ul>\nThese methods do need some addition parameters to specify the validator. So\nthere is no check function which you can use in other contexts because the\ncheck function for the validation is created based on the given parameter.</p>\n\n<p><strong>Example usage for a property</strong></p>\n\n<code>validate: qx.util.Validate.number()</code>\n\n<code>validate: qx.util.Validate.range(0, 100)</code>\n\n<p>Because the methods without the check prefix return a validation method,\nthe function must be called at the property definition. So don&#8217;t forget the \nending brackets for those methods without parameters!\nFor the right usage, take a additionally look at the documentation of the \n{@link qx.core.Property} class.</p>"}},{type:"methods-static",children:[{type:"method",attributes:{"isStatic":"true","name":"checkColor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>The value to check.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>The function checks the incoming value to see if it is a color. \nIf not, an ValidationError will be thrown. The check itself will be\ndelegated to the {@link qx.util.ColorUtil#stringToRgb} method.\nIf you want to use the color check in a property definition, \nuse the {@link #color} method.</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"checkEmail"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>The value to check.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>The function checks the incoming value to see if it is a email address. \nIf not, an ValidationError will be thrown.\nIf you want to use the email check in a property definition, \nuse the {@link #email} method.</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"checkNumber"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>The value to check.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>The function checks the incoming value to see if it is a number. \nIf not, an ValidationError will be thrown.\nIf you want to use the number check in a property definition, \nuse the {@link #number} method.</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"checkString"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>The value to check.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>The function checks the incoming value to see if it is a string. \nIf not, an ValidationError will be thrown.\nIf you want to use the string check in a property definition, \nuse the {@link #string} method.</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"checkUrl"},children:[{type:"params",children:[{type:"param",attributes:{"name":"value"},children:[{type:"desc",attributes:{"text":"<p>The value to check.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>The function checks the incoming value to see if it is an url. \nIf not, an ValidationError will be thrown.\nIf you want to use the url check in a property definition, \nuse the {@link #url} method.</p>"}}]},{type:"method",attributes:{"isStatic":"true","name":"color"},children:[{type:"desc",attributes:{"text":"<p>Returns the function that checks for a color.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The {@link #checkColor} Function.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"email"},children:[{type:"desc",attributes:{"text":"<p>Returns the function that checks for a email address.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The {@link #checkEmail} Function.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"inArray"},children:[{type:"params",children:[{type:"param",attributes:{"name":"array"},children:[{type:"desc",attributes:{"text":"<p>The array holding the possibilities.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Array"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns a function that checks if the given value is in the array.\nIf the value given to the returned function is not in the array, a\nValidationError will be thrown.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A function taking one parameter (value).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"number"},children:[{type:"desc",attributes:{"text":"<p>Returns the function that checks for a number.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The {@link #checkNumber} Function.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"range"},children:[{type:"params",children:[{type:"param",attributes:{"name":"from"},children:[{type:"desc",attributes:{"text":"<p>The lower border of the range.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]},{type:"param",attributes:{"name":"to"},children:[{type:"desc",attributes:{"text":"<p>The upper border of the range.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Number"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns a function that checks if the number is in the given range. \nThe range includes the border values.\nA range from 1 to 2 accepts the values 1 equally as everything up to 2 \nincluding the 2.\nIf the value given to the returned function is out of the range, a\nValidationError will be thrown.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A function taking one parameter (value).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"regExp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"reg"},children:[{type:"desc",attributes:{"text":"<p>The RegExp for the check.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"RegExp"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns a function that checks if the given value fits the RegExp.\nFor testing, the function uses the RegExp.test function.\nIf the value given to the returned function does not fit the RegExp, a\nValidationError will be thrown.\nincoming</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>A function taking one parameter (value).</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"string"},children:[{type:"desc",attributes:{"text":"<p>Returns the function that checks for a string.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The {@link #checkString} Function.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]},{type:"method",attributes:{"isStatic":"true","name":"url"},children:[{type:"desc",attributes:{"text":"<p>Returns the function that checks for a url.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The {@link #checkUrl} Function.</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Function"}}]}]}]}]}]}