{type:"class",attributes:{"name":"DragDrop","packageName":"qx.event.handler","superClass":"qx.core.Object","fullName":"qx.event.handler.DragDrop","type":"class","interfaces":"qx.event.IEventHandler"},children:[{type:"desc",attributes:{"text":"<p>Event handler, which supports drag events on <span class=\"caps\">DOM</span> elements.</p>"}},{type:"constructor",children:[{type:"method",attributes:{"overriddenFrom":"qx.core.Object","isCtor":"true","name":"ctor"},children:[{type:"params",children:[{type:"param",attributes:{"name":"manager"},children:[{type:"desc",attributes:{"text":"<p>Event manager for the window to use</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.Manager"}}]}]}]}]}]},{type:"constants",children:[{type:"constant",attributes:{"name":"PRIORITY"},children:[{type:"desc",attributes:{"text":"<p>Priority of this handler</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"constant",attributes:{"type":"Boolean","name":"IGNORE_CAN_HANDLE","value":"true"},children:[{type:"desc",attributes:{"text":"<p>Whether the method &#8220;canHandleEvent&#8221; must be called</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Integer"}}]}]},{type:"constant",attributes:{"name":"SUPPORTED_TYPES"},children:[{type:"desc",attributes:{"text":"<p>Supported event types</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Map"}}]}]}]},{type:"methods",children:[{type:"method",attributes:{"access":"private","name":"__clearInit"},children:[{type:"desc",attributes:{"text":"<p>Clean up event listener and structures when a drag was ended without ever starting into session mode\n(e.g. not reaching the required offset before)</p>"}}]},{type:"method",attributes:{"access":"private","name":"__clearSession"},children:[{type:"desc",attributes:{"text":"<p>Cleans up a drag&amp;drop session when <code>dragstart</code> was fired before.</p>"}}]},{type:"method",attributes:{"access":"private","name":"__detectAction"},children:[{type:"desc",attributes:{"text":"<p>Detects the current action and stores it under the private\nfield <code>__currentAction</code>. Also fires the event\n<code>dragchange</code> on every modification.</p>"}}]},{type:"method",attributes:{"access":"private","name":"__findDraggable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"elem"},children:[{type:"desc",attributes:{"text":"<p>The element to query</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Finds next draggable parent of the given element. Maybe the element itself as well.</p>\n\n<p>Looks for the attribute <code>qxDraggable</code> with the value <code>on</code>.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The next parent element which is draggable. May also be <code>null</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__findDroppable"},children:[{type:"params",children:[{type:"param",attributes:{"name":"elem"},children:[{type:"desc",attributes:{"text":"<p>The element to query</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"desc",attributes:{"text":"<p>Finds next droppable parent of the given element. Maybe the element itself as well.</p>\n\n<p>Looks for the attribute <code>qxDroppable</code> with the value <code>on</code>.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The next parent element which is droppable. May also be <code>null</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Element"}}]}]}]},{type:"method",attributes:{"access":"private","name":"__fireEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>Event type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"target"},children:[{type:"desc",attributes:{"text":"<p>Target to fire on</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Object"}}]}]},{type:"param",attributes:{"name":"cancelable"},children:[{type:"desc",attributes:{"text":"<p>Whether the event is cancelable</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]},{type:"param",attributes:{"name":"original"},children:[{type:"desc",attributes:{"text":"<p>Original mouse event</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Wrapper for {@link qx.event.Registration#fireEvent} for drag&amp;drop events\nneeded in this class.</p>"}}]},{type:"method",attributes:{"access":"private","name":"__rebuildStructures"},children:[{type:"desc",attributes:{"text":"<p>Rebuilds the internal data storage used during a drag&amp;drop session</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onKeyDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeySequence"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for root&#8217;s <code>keydown</code> event</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onKeyUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.KeySequence"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for root&#8217;s <code>keyup</code> event</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onMouseDown"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for root&#8217;s <code>mousedown</code> event</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onMouseMove"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for root&#8217;s <code>mousemove</code> event</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onMouseOut"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for root&#8217;s <code>mouseout</code> event</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onMouseOver"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for root&#8217;s <code>mouseover</code> event</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onMouseUp"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Mouse"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for root&#8217;s <code>mouseup</code> event</p>"}}]},{type:"method",attributes:{"access":"protected","name":"_onWindowBlur"},children:[{type:"params",children:[{type:"param",attributes:{"name":"e"},children:[{type:"desc",attributes:{"text":"<p>Event object</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"qx.event.type.Event"}}]}]}]},{type:"desc",attributes:{"text":"<p>Event listener for window&#8217;s <code>blur</code> event</p>"}}]},{type:"method",attributes:{"name":"addAction"},children:[{type:"params",children:[{type:"param",attributes:{"name":"action"},children:[{type:"desc",attributes:{"text":"<p>The action to add</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Registers a supported action. One of <code>move</code>,\n<code>copy</code> or <code>alias</code>.</p>"}}]},{type:"method",attributes:{"name":"addData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>Any valid type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]},{type:"param",attributes:{"name":"data"},children:[{type:"desc",attributes:{"text":"<p>Any data to store</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"desc",attributes:{"text":"<p>Adds data of the given type to the internal storage. The data\nis available until the <code>dragend</code> event is fired.</p>"}}]},{type:"method",attributes:{"name":"addType"},children:[{type:"params",children:[{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>The type to add</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Registers a supported type</p>"}}]},{type:"method",attributes:{"docFrom":"qx.event.IEventHandler","name":"canHandleEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"target"}},{type:"param",attributes:{"name":"type"}}]}]},{type:"method",attributes:{"name":"getCurrentAction"},children:[{type:"desc",attributes:{"text":"<p>Returns the currently selected action (by user keyboard modifiers)</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>One of <code>move</code>, <code>copy</code> or\n   <code>alias</code></p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"name":"getCurrentType"},children:[{type:"desc",attributes:{"text":"<p>Returns the type which was requested last.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The last requested data type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"method",attributes:{"name":"getData"},children:[{type:"params",children:[{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>Any supported type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Returns the data of the given type during the <code>drop</code> event\non the drop target. This method fires a <code>droprequest</code> at\nthe drag target which should be answered by calls to {@link #addData}.</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>The result data</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"var"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.event.IEventHandler","name":"registerEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"target"}},{type:"param",attributes:{"name":"type"}},{type:"param",attributes:{"name":"capture"}}]}]},{type:"method",attributes:{"name":"supportsAction"},children:[{type:"params",children:[{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>Any type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Whether the current drag target supports the given action</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the action is supported</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"name":"supportsType"},children:[{type:"params",children:[{type:"param",attributes:{"name":"type"},children:[{type:"desc",attributes:{"text":"<p>Any type</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"String"}}]}]}]},{type:"desc",attributes:{"text":"<p>Whether the current drag target supports the given type</p>"}},{type:"return",children:[{type:"desc",attributes:{"text":"<p>Whether the type is supported</p>"}},{type:"types",children:[{type:"entry",attributes:{"type":"Boolean"}}]}]}]},{type:"method",attributes:{"docFrom":"qx.event.IEventHandler","name":"unregisterEvent"},children:[{type:"params",children:[{type:"param",attributes:{"name":"target"}},{type:"param",attributes:{"name":"type"}},{type:"param",attributes:{"name":"capture"}}]}]}]}]}